---
title: Design Patterns
localeTitle: Шаблоны проектирования
---
## Шаблоны проектирования

Программисты и разработчики программного обеспечения используют шаблоны проектирования для решения **общих, повторяющихся проблем** в архитектуре программного обеспечения. Шаблоны обеспечивают язык-агностический подход к **объектно-ориентированному программированию,** который помогает разработчикам следовать принципам хорошего дизайна приложений.

### Почему дизайн шаблонов?

Разработка по шаблонам проектирования имеет ряд преимуществ:

*   Легче следовать хорошим принципам программирования, таким как **[принципы](https://medium.com/@cramirez92/s-o-l-i-d-the-first-5-priciples-of-object-oriented-design-with-javascript-790f6ac9b9fa) [SOLID](https://www.youtube.com/watch?v=XzdhzyAukMM) .**
*   Он уменьшает куски кода, поэтому код легче **тестировать** и **отлаживать**
*   Это помогает поддерживать слабосвязанный код, поэтому код проще **повторять** и **обновлять** для новых приложений
*   Это упрощает **понимание** кода, поэтому новые участники могут **быстро наращивать скорость**

Использование шаблонов проектирования требует некоторых компромиссов, а разработчики, новые для практики, должны помнить следующее:

*   В программировании **нет серебряных пуль** , а шаблоны проектирования не являются исключением
*   Шаблоны проектирования добавляют **слой абстракции** к коду, который увеличивает первоначальный дизайн и усилия по разработке
*   Чрезмерное использование шаблонов дизайна или принуждение их к установке **затрудняет** понимание кода

### Поддержка языков

Шаблоны проектирования возникли из мира статически типизированных языков, таких как C ++, Java и C #. Большинство ресурсов о разработке по шаблону проектирования основаны на одном из этих языков.

Тем не менее, шаблоны проектирования таковы: шаблоны. Они **не** являются **реализациями** , такими как классы или интерфейсы, и **не ограничены каким-либо одним языком** .

При изучении шаблонов проектирования в динамическом языке, если определенные шаблоны кажутся излишне сложными или противоречивыми, вспомните их происхождение. Разработчики на динамических языках могут по-прежнему использовать и использовать следующие шаблоны проектирования, хотя для их полного изучения может потребоваться больше исследований.

### Пользы

Конструктивные шаблоны превосходны при решении проблем основополагающего кодирования простым и повторяемым способом. В целом они делятся на три категории:

*   Шаблоны **создания** описывают, как создавать новые объекты
*   **Структурные** шаблоны описывают, как составлять объекты из других объектов
*   **Поведенческие** модели описывают, как объекты общаются друг с другом

Эти задачи могут выполняться без шаблонов проектирования, но шаблоны проектирования **уменьшают риск того,** что вы нарушите передовую практику и создадите код, который трудно поддерживать.

#### Дополнительная информация:

*   [Шаблоны дизайна](https://github.com/kamranahmedse/design-patterns-for-humans) Kamran Ahmed [для людей](https://github.com/kamranahmedse/design-patterns-for-humans) - отличное введение в конкретные шаблоны
*   [Design Patterns](https://en.wikipedia.org/wiki/Design_Patterns) - это книга, которая начала эту практику
*   [Шаблоны Enterprise Application Architecture от](https://martinfowler.com/eaaCatalog/) Martin Fowler предоставляют набор более сложных шаблонов для корпоративных приложений
*   Sourcemaking предоставляет [онлайн-ресурс](https://sourcemaking.com/design_patterns) дополнительные примеры и информацию о шаблонах проектирования