---
title: Observer pattern
localeTitle: Схема наблюдателя
---
Шаблон Observer предлагает модель подписки, в которой объекты подписываются на событие и получают уведомление при возникновении события.

## Схема наблюдателя

Этот шаблон является основой программирования, управляемого событиями. В Front End Development это важная модель, позволяющая жестко масштабировать вашу прикладную логику. В этой схеме вы делаете разницу между **субъектом** и **наблюдателями** . Субъектами являются сами события, такие как _щелчок_ , _нажатие клавиши_ или сигнал с сервера. Все подписные **наблюдатели** уведомляются, когда субъект меняет состояние (когда срабатывает событие). Для получения дополнительной информации о событиях читайте здесь [Evenet Driven программирования](https://www.technologyuk.net/software-development/designing-software/event-driven-programming.shtml)

### Подписавшись

Преимуществом этого шаблона является сбор подписных объектов, которые будут реагировать на событие вместо вызова функции для каждого объекта, который должен быть уведомлен. Другим преимуществом является то, что наблюдатели подписываются через интерфейс, который позволяет изменять функцию события только внутри функции.

## Другие источники

Пример кода и многое другое в [шаблоне проектирования Observer](http://www.dofactory.com/javascript/observer-design-pattern)