---
title: Quality Assurance
localeTitle: Гарантия качества
---
## Гарантия качества

Обеспечение качества (обычно называемое QA) - это средство, с помощью которого проверяется продукт в разработке, чтобы убедиться, что он работает так, как предполагается. Фактические методы, используемые в процессах QA, сильно различаются в зависимости от размера и характера продукта.

Для личного проекта вы, вероятно, просто испытаете, когда идете, и попросите других предоставить отзывы на соответствующих этапах. Напротив, банковское приложение должно иметь каждый аспект каждой функции, полностью проверенной и документированной, чтобы гарантировать ее функциональность и безопасность.

Независимо от того, насколько формальным или подробным является процесс QA, его цель - выявить ошибки, чтобы их можно было решить до выпуска продукта.

### методологии

#### проворный

В гибком подходе к развитию цель состоит в том, что каждый цикл работы («спринт») создает рабочее программное обеспечение, которое может быть добавлено и улучшено на итеративном уровне. Это делает QA процессом неотъемлемой частью цикла разработки. Проверяя программные компоненты на каждом этапе их производства, вы уменьшаете риск появления ошибок при выпуске.

### терминология

#### Тестирование автоматизации

Тестирование выполняется с помощью предварительно написанных сценариев, предназначенных для контроля выполнения тестов.

#### Черный ящик

Эти тесты не смотрят внутри тестируемой системы, но рассматривают ее как «закрытую» так же, как это испытывает ее конечный пользователь.

#### дефект

Любое отклонение от спецификации приложения; часто упоминается как «ошибка».

#### Экспериментальное тестирование

Неописанный подход к тестированию, основанный на уникальном творчестве тестировщика в попытке найти неизвестные ошибки и идентифицировать регрессии.

#### Интеграционное тестирование

Тестирование отдельных компонентов / модулей вместе для обеспечения надежного соединения и взаимодействия друг с другом.

#### Тестирование отрицательного пути

Сценарий тестирования, разработанный для создания состояния ошибки в функции / приложении и проверки того, что ошибка обрабатывается изящно. Примером этого является ввод ряда чисел в поле электронной почты в форме регистрации пользователя и проверка того, чтобы регистрация не принималась до тех пор, пока не будет предоставлен фактический адрес электронной почты.

#### Регрессионное тестирование

Тестирование сделано на новой сборке для обеспечения того, чтобы новая функциональность не случайно не нарушила ранее протестированные функциональные возможности.

#### Дымовые испытания

Минималистский подход к тестированию, предназначенный для обеспечения базовых функциональных возможностей, работает до проведения более глубокого тестирования. Обычно это происходит в начале процесса тестирования.

#### Прецедент

Указанные предварительные условия, этапы и ожидаемые результаты, на которые указывает тестер / инженер QA, чтобы определить, выполняет ли функция свою задачу, как ожидалось.

#### Белая коробка

Относится к испытаниям, выполненным на структурном уровне, в рамках кодовой базы. Программисты, проверяющие, что входы и выходы из определенных функций или компонентов будут тестироваться с помощью белого ящика.

Также известен как «Стеклянная коробка», «Ясная коробка», «Прозрачная коробка», потому что тестер может «видеть внутри» тестируемой системы.

Основные категории

*   **Единичные тесты** (отдельные единицы кода делают то, что им нужно)
*   **Интеграционные тесты** (единицы / компоненты взаимодействуют друг с другом должным образом)
*   **Регрессионные тесты** (повторное применение тестов на более поздних этапах разработки для обеспечения их работы)

Существует три основных метода:

*   **Разделение эквивалентности** (проверенные входные значения являются репрезентативными для больших входных наборов данных)
*   **Анализ граничных значений** (система тестируется с выбранными входами, где поведение и, следовательно, выход должны меняться)
*   **Графический анализ причинно-следственных связей** (тесты основаны на визуализации отношений ввода-вывода)

### Другие источники

[Разработка управляемых тестов (руководство FreeCodeCamp)](https://guide.freecodecamp.org/agile/test-driven-development)

# [Единичные тесты (руководство FreeCodeCamp)](https://guide.freecodecamp.org/software-engineering/unit-tests/)

[Основы тестирования программного обеспечения](http://softwaretestingfundamentals.com/)