---
title: Unit Tests
localeTitle: Тесты модулей
---
## Тесты модулей

Модульное тестирование - это тип тестирования, который находится в нижней части пирамиды тестирования программного обеспечения. Это включает в себя разбивку кодовой базы на более мелкие части (или единицы) и тестирование их по отдельности. В зависимости от типа языка программирования (или парадигмы) это может быть против всего, что вы определяете как единицу, хотя наиболее распространенная практика - это функции.

### Почему?

*   **Защита** - Тестирование модулей защищает от введения новых или старых ошибок для защитного программирования
*   **Уверенность** - вы можете добавлять изменения или повторное использование или код рефакторинга (оба очень распространенные) и быть уверенным, что вы не добавили ошибку
*   **Документация** - модульное тестирование документирует поведение и поток кода, поэтому его легко понять, кто-то новый для кода, чтобы понять его
*   **Изоляция** - изолирует модуль от всей функции. Этот подход заставляет вас думать о модуле сам по себе и спрашивать, какова его работа?
*   **Качество.** Поскольку модульное тестирование заставляет вас думать и использовать свой собственный API, он обеспечивает хорошие / расширяемые интерфейсы и шаблоны. Он может указывать на какую-либо жесткую связь или чрезмерную сложность, которая должна быть решена. Плохой код обычно намного сложнее проверить
*   **Промышленный стандарт.** Единичное тестирование в наши дни является общей дисциплиной, и это требование для значительной части программных компаний
*   **Меньше ошибок.** Существенные исследования показывают, что применение теста к приложению может снизить плотность ошибок в производстве на 40% - 80%.

### Пример (в Javascript)

Предположим, что существует функция, написанная в файле **add.js**

```javascript
var add = function(number1, number2){ 
  return number1 + number2; 
 } 
```

Теперь, чтобы написать единичный тест этой конкретной функции, мы можем использовать инструменты тестирования, такие как [mocha](http://mochajs.org/)

```javascript
const mocha = require('mocha') 
 const chai = require('chai')  // It is an assertion library 
 describe('Test to check add function', function(){ 
  it('should add two numbers', function(){ 
    (add(2,3)).should.equal(5)  //Checking that 2+3 should equal 5 using the given add function 
  }); 
 }); 
```

### Тестирование

Модульное тестирование является ключевой особенностью подхода разработки программного обеспечения (TDD) для разработки программного обеспечения. В этом подходе код для конкретных функций или функций записывается путем повторного использования очень короткого цикла. Во-первых, разработчик пишет набор автоматизированных модульных тестов и гарантирует, что они не сработают изначально. Затем разработчик реализует минимальный минимальный код, необходимый для прохождения тестовых примеров. После подтверждения того, что код ведет себя так, как ожидалось, разработчик затем возвращается и код рефакторинга придерживается любых соответствующих стандартов кодирования.

### Больше информации

Мартин Фаулер на [модульном](https://www.martinfowler.com/bliki/UnitTest.html) тестировании: [martinfowler.com](https://www.martinfowler.com/bliki/UnitTest.html)

Роберт Мартин aka «Доктор Боб» на TDD: [butunclebob.com](http://www.butunclebob.com/ArticleS.UncleBob.TheThreeRulesOfTdd)

Эрик Эллиот о модульных тестах и ​​TDD: [средний](https://medium.com/javascript-scene/5-common-misconceptions-about-tdd-unit-tests-863d5beb3ce9)