---
title: Version Control System
localeTitle: Система управления версиями
---
## Система управления версиями

Системы контроля версий (VCS), также называемые «Управление исходными кодами» (SCM), являются инструментами, используемыми для отслеживания изменений в файлах, управления версиями и упрощения совместной работы с файлами. Существует, главным образом, 2 типа VCS:

*   Централизованная система контроля версий Там, где центральный репозиторий является авторитетным. Связанная архитектура - клиент / сервер. Первыми VCS (CVS, SVN ...) были Централизованная система контроля версий.
*   Система управления распределенной версией Где несколько изменений обмена репозиториев. Связанная архитектура в основном сопоставляется с одноранговым узлом, но одно репо может быть объявлено как авторитетное. Наиболее используемыми современными VCS (Git, Mercurial ...) являются система управления распределенной версией.

### Зачем использовать его?

*   **История изменений** - VCS позволяет пользователю просматривать и выполнять поиск всех изменений, которые автоматически записываются с полезной информацией (дата, автор ...) и
*   **Версии / теги** . Пользователь может искать / извлекать определенное состояние файлов, помеченных метками и именами версий.
*   **Ветвление / слияние** - система управления распределенной версией позволяет легко поддерживать параллельную ветвь файлов и частично или полностью объединять их при необходимости.
*   **Атомные операции.** Все современные VCS обеспечивают атомарные операции: все модификации гарантированно преуспеют или терпят неудачу в целом, гарантируя, что файлы всегда находятся в согласованном состоянии.

### Самая популярная система контроля версий

*   Гит

_Git_ - это система управления распределенной версией и, вероятно, наиболее часто используемый VCS, используемый в настоящее время с _Mercurial_ .

*   ртутный

_Mercurial_ - это система управления распределенной версией и, вероятно, наиболее используемый VCS, используемый в настоящее время с _Git_ .

*   CVS

_CVS_ - это старый SCM, который был распространен до распространения _SVN_ . _CVS_ и _SVN_ теперь устарели в пользу системы управления распределенной версией, такой как _Git_ и _Mercurial_ .

*   SVN / Subversion

_SVM_ - это старый SCM, который преуспел в _CVS_ . В конечном итоге _SVN_ устарела благодаря широкому внедрению системы управления распределенной версией, такой как _Git_ и _Mercurial_

### Дополнительная информация:

[CVS](http://savannah.nongnu.org/projects/cvs)

[Гит](https://git-scm.com/)

[ртутный](https://www.mercurial-scm.org/)

[SVN](http://subversion.tigris.org/)

[Управление версиями в Википедии](https://en.wikipedia.org/wiki/Version_control)