---
title: SQL CREATE INDEX Statement
localeTitle: Заявление SQL CREATE INDEX
---
## Заявление SQL CREATE INDEX

Этот оператор используется для создания «индекса» в столбце в существующей таблице.

Ключевые моменты по индексам:

*   Они используются для повышения эффективности поиска данных, представления данных в определенном порядке, при соединении таблиц (см. «Руководства« JOIN ») и т. Д.
*   Индекс - это «системный» объект, что означает, что он используется менеджером базы данных.
*   Часть этого использования предназначена для того, чтобы менеджер баз данных обновил индекс, когда данные, используемые индексом, изменяются в связанной таблице. Помните об этом, поскольку по мере увеличения числа индексов в общей производительности системы может пострадать общая производительность системы.
*   Если вы обнаружите, что ваши SQL-запросы работают медленнее в данной таблице или таблицах, создание индекса - это первое, что нужно учитывать, чтобы исправить проблему.

Ниже приведен пример синтаксиса инструкции Create Index. Обратите внимание, что синтаксис позволяет индексировать более одного столбца.

```sql
CREATE INDEX index_name 
 ON table_name (column1, column2, ...); 
```

Создание нового индекса в поле таблицы ученика, programOfStudy. Для справки, вот текущее определение таблицы учеников.

![Изображение-1](https://github.com/SteveChevalier/guide-images/blob/master/create-index-statement01.JPG?raw=true)

Вот инструкция для создания индекса и снимок экрана обновленного определения таблицы:

```sql
create index pStudyIndex 
 on student (programOfStudy); 
```

![Изображение-1](https://github.com/SteveChevalier/guide-images/blob/master/create-index-statement02.JPG?raw=true)

В MySQL вы используете команду ALTER TABLE для изменения и удаления индексов. MySQL Workbench также предоставляет инструменты графического интерфейса для управления индексами.

Как и во всех этих вещах, есть намного больше, поэтому, пожалуйста, см. Руководство для своего менеджера баз данных и получайте удовольствие, пытаясь использовать различные варианты самостоятельно.