---
title: SQL Create Table
localeTitle: SQL Create Table
---
# SQL CREATE TABLE

## Введение

Это руководство представляет собой обзор `CREATE TABLE` функций SQL `CREATE TABLE` .

Мы будем использовать MySQL для всех примеров в этих руководствах freeCodeCamp SQL. MySQL часто используется на веб-сайтах для бэкэнд-базы данных, 2) он бесплатный, и он интересен и прост в использовании.

## В этом руководстве

*   Создание схемы, контейнера для всех наших объектов базы данных.
*   Создайте таблицу, чтобы мы могли что-то изменить.
*   Создание таблицы путем импорта CSV-файла и изменения этой таблицы
*   Создание таблицы с помощью инструмента Workbench MySQL

Мы выполняем большую часть этой работы с операторами SQL в инструменте сценариев Workbench MySQL. Мы также увидим, как создать таблицу, используя интерфейс workbench, вместо SQL-операторов.

## Структура высокого уровня реляционной базы данных

1.  Высший уровень; База данных; установка системы базы данных. В этом случае это MySQL. Вызывается «Локальный экземпляр MySQL Router» на снимках экрана выше.
2.  Далее - схема; контейнер для объектов, необходимых для управления данными в системе реляционных баз данных.
3.  Объекты, которые мы создаем (таблицы, индексы, хранимые процедуры, функции) для управления системой и ее данными

![Изображение-1](https://github.com/SteveChevalier/guide-images/blob/master/create_table01.JPG?raw=true)

## Создание схемы MySQL

Схема представляет собой контейнер для объектов, необходимых для управления данными для данного объекта или процесса. Мы приводим примеры, когда мы продвигаемся в этом руководстве.

Мы создадим схему для нашего обучения и тестирования с помощью команды SQL;
```
create database fCC_alterTableGuide; 
```

Эта структура схемы экземпляров до запуска этой команды

![Изображение-2](https://github.com/SteveChevalier/guide-images/blob/master/create_table02.JPG?raw=true)

Эта структура схемы экземпляров после запуска оператора SQL

![Изображение-3](https://github.com/SteveChevalier/guide-images/blob/master/create_table03.JPG?raw=true)

## Создание таблицы, добавление тестовых данных с помощью «вставки», переименование таблицы (изменить)

Мы создадим таблицу учеников.

Этапы:

1.  убедитесь, что у нас нет таблицы уже
    
2.  создать таблицу
    
3.  вставьте тестовые данные.
    

*   Типы данных: имя студента - это поле персонажа, ограниченное 90 символами
*   Идентификатор студента - это число (целое число) (диапазон от -2147483648 до 2147483647). Это будет основным ключом для таблицы и будет автоматически увеличиваться при добавлении записи.
*   Также будут два поля «отметка времени», в которые

Создать инструкцию и отображение результатов выполнения;

![Изображение-4](https://github.com/SteveChevalier/guide-images/blob/master/create_table04.JPG?raw=true)

Используя оператор Select, мы увидим, что таблица есть, но теперь записи были добавлены.

![Изображение-5](https://github.com/SteveChevalier/guide-images/blob/master/create_table05.JPG?raw=true)

Теперь, чтобы вставить некоторые данные и посмотреть, как выглядит наша новая таблица с записями в ней (и понимать временные метки создания и обновления);

![Изображение-6](https://github.com/SteveChevalier/guide-images/blob/master/create_table06.JPG?raw=true)

Первая метка времени - это данные и время создания, а вторая - дата и время обновления. Изменение записи должно обновлять ts2, но не ts1. Давайте взглянем.

![Изображение-7](https://github.com/SteveChevalier/guide-images/blob/master/create_table07.JPG?raw=true)

## Создайте таблицу с помощью MySql Workbench

Щелкните правой кнопкой мыши по «Таблицам» в схеме, в которую вы хотите добавить новый файл. Выберите «Создать таблицу».

![Изображение-8](https://github.com/SteveChevalier/guide-images/blob/master/create_table08.JPG?raw=true)

Заполните форму по желанию и нажмите «Применить».

![Изображение-9](https://github.com/SteveChevalier/guide-images/blob/master/create_table09.JPG?raw=true)

## Создать таблицу как Select (CTAS)

Быстрый способ создания копии таблицы, включая данные, - создать таблицу как выбранную.

CREATE TABLE my _table as (SELECT \* FROM orig_ tbl);

## Создание и заполнение таблицы путем импорта CSV-файла

Щелкните правой кнопкой мыши по «Таблицам» по схеме, в которую вы хотите добавить новый файл. Выберите «Импорт данных таблицы».

![Изображение-10](https://github.com/SteveChevalier/guide-images/blob/master/create_table10.JPG?raw=true)

Выберите файл CSV для импорта и нажмите NEXT Обычно вы создаете новую таблицу из данных, выбираете нужные параметры и нажимаете NEXT

![Изображение-11](https://github.com/SteveChevalier/guide-images/blob/master/create_table11.JPG?raw=true)

При необходимости отрегулируйте типы данных и нажмите «Далее»

![Изображение-12](https://github.com/SteveChevalier/guide-images/blob/master/create_table12.JPG?raw=true)

Щелкните NEXT (на этом экране и следующем, который отображается), чтобы импортировать данные в таблицу Вы увидите статус завершения, просмотрите и нажмите ОКРАСКА

![Изображение-13](https://github.com/SteveChevalier/guide-images/blob/master/create_table13.JPG?raw=true)

![Изображение-14](https://github.com/SteveChevalier/guide-images/blob/master/create_table14.JPG?raw=true)

## Другие материалы

Там гораздо больше деталей для освещения этой темы, поэтому установите MySQL и получайте удовольствие!

### Где получить MySQL

Попробуйте \[эта загрузка для пользователей Windows \[(https://dev.mysql.com/downloads/windows/)

### Документация MySQL

*   [справочная страница](https://dev.mysql.com/doc/refman/5.7/en/alter-table.html)
*   [примеры из руководства](https://dev.mysql.com/doc/refman/5.7/en/alter-table-examples.html)

### Документация по SQL Server

*   [Документы Microsoft](https://docs.microsoft.com/en-us/sql/t-sql/statements/create-table-transact-sql)