---
title: SQL Data Types
localeTitle: Типы данных SQL
---


# Типы данных SQL

Каждый столбец в таблице должен иметь тип данных. Он указывает тип значения, которое хранит столбец.

Каждая база данных может принимать разные типы данных, но в целом список типов данных следующий:


### Типы строк
Тип данных | Описание
------------ | -------------
`CHAR(n)`| Строка символов. Фиксированная длина n. Минимальная длина равна 1. Если вы назначаете значение столбцу CHAR, содержащему меньше символов, чем заданная длина, оставшееся пространство заполняется пробелами.
`VARCHAR(n)` | Строка символов. Переменная длина. Максимальная длина n. Минимальная длина: 1
`BINARY(n)` | Двоичная строка. Фиксированная длина n
`VARBINARY(n)` or `BINARY VARYING(n)` | Двоичная строка. Переменная длина. Максимальная длина n

### Типы номеров
Тип данных | Описание
------------ | -------------
`INTEGER` | Целочисленное числовое. От -2,147,483,648 до 2,147,483,647.
`SMALLINT` | Целочисленное числовое. От -32,768 до 32,767
`BIGINT` | Целочисленное числовое. От -9,223,372,036,854,775,808 до 9,223,372,036,854,775,807
`DECIMAL(p,s)` или `NUMERIC(p,s)` | Точные численные, точность p, масштаб s. Точность - это максимальное общее число десятичных цифр, которое будет храниться как слева, так и справа от десятичной точки. Масштаб - это число десятичных цифр, которое будет храниться справа от десятичной точки. Это число вычитается из p для определения максимального количества цифр слева от десятичной точки. Пример: десятичный (5,2) - это число, которое имеет 3 цифры до десятичной и 2 цифры после десятичной.
`FLOAT(p)` | Приблизительная численная точность мантиссы p. Плавающее число в экспоненциальной ноте базы 10. Аргумент размера для этого типа состоит из одного числа, определяющего минимальную точность
`REAL` | Приблизительная численная точность мантиссы 7
`FLOAT` | Приблизительная численная точность мантиссы 16
`DOUBLE PRECISION` | Приблизительная численная точность мантиссы 16

### Типы даты и времени
Тип данных | Описание
------------ | -------------
`DATE` | Сохраняет значения года, месяца и дня
`TIME` | Хранит часы, минуты и секунды.
`DATETIME` | Хранит время в виде целого числа вида YYYYMMDDHHMMSS
`TIMESTAMP` | Сохраняет количество секунд с момента Unix
`TIME WITH TIME ZONE` | Сохраняет время суток с часовым поясом
`TIMESTAMP WITH TIME ZONE` | Сохраняет временную метку с часовым поясом

### Другие типы данных
Тип данных | Описание
------------ | -------------
`BOOLEAN` | Сохраняет значения `TRUE` или `FALSE` values
`ARRAY` | Набор длины и упорядоченный набор элементов
`MULTISET` | Набор элементов с переменной длиной и неупорядоченностью
`XML` | Сохраняет XML-данные
