---
title: SQL Drop View Statement
localeTitle: SQL Drop View Statement
---
## SQL Drop View Statement

### Введение

Это руководство охватывает инструкцию SQL для удаления (удаления) одного или нескольких объектов вида.

Вид - это объект, представляющий данные из одной или нескольких таблиц.

Примечание: перед удалением или изменением данных или объектов не забудьте обновить резервную копию.

Мы рассмотрим:

*   Использование SQL для вывода таблицы
*   Использование инструментария для удаления представления

Мы будем использовать MySQL для демонстрации. Проверьте руководство для этой функции в других менеджерах баз данных.

Мы отбросим представление под названием `students_dropMe_v` , которое было создано именно для этой цели.

### Основной синтаксис

```sql
DROP VIEW [IF EXISTS] 
    view_name [, view_name] ... 
```

### Drop View SQL

Часть if if будет «ловушки», если вид не существует.

```sql
drop view if exists students_dropMe_v; 
```

Вид после создания:

![Изображение-1](https://github.com/SteveChevalier/guide-images/blob/master/drop-view01.JPG)

Вышеуказанная команда выполнена и показаны:

![Изображение-2](https://github.com/SteveChevalier/guide-images/blob/master/drop-view02.JPG)

### Использование Workbench

Из рабочего места: 1) Щелкните правой кнопкой мыши на изображении, чтобы 2) выберите в меню 3) Выберите либо a) запустите SQL, чтобы просмотреть исполняемый оператор SQL, либо b) отбросить новый

![Изображение-3](https://github.com/SteveChevalier/guide-images/blob/master/drop-view03.JPG)

\* Как и все эти SQL-вещи, им гораздо БОЛЬШЕ, чем тому, что находится в этом вводном руководстве. Надеюсь, это, по крайней мере, даст вам достаточно, чтобы начать.

Пожалуйста, ознакомьтесь с руководством для своего менеджера баз данных и получайте удовольствие от различных вариантов самостоятельно. \*

### дополнительный

Вот SQL, который я использовал для создания таблицы, которую мы только что сбросили:

```sql
create view `students_dropMe_v` as 
 select FullName, programOfStudy 
 from student 
 where programOfStudy = 'Programming'; 

```