---
title: SQL Foreign Key Constraint
localeTitle: Ограничение внешнего ключа SQL
---
## Ограничение внешнего ключа SQL

Внешний ключ - это ключ, используемый для связывания двух таблиц. Таблица с Ограничением внешнего ключа (так называемая «дочерняя таблица») связана с другой таблицей (иначе говоря, «родительская таблица»). Соединение между внешним ключом дочерней таблицы и основным ключом родительской таблицы.

Внешние ограничения ключей используются для поддержания согласованности между таблицами. Например, если запись родительской таблицы удалена и дочерняя таблица имеет записи, система также может удалить дочерние записи.

Они также помогают предотвратить ввод неточных данных в дочернюю таблицу, требуя, чтобы запись родительской таблицы существовала для каждой записи, введенной в дочернюю таблицу.

### Пример использования

В этом руководстве мы более подробно рассмотрим таблицы учеников (родителей) и учеников (детей).

### Основной ключ родительской таблицы

Обратите внимание, что таблица учеников имеет первичный ключ одного столбца studentID.

```sql
SHOW index FROM student; 
```

```text
+---------+------------+----------+--------------+-------------+ 
 | Table   | Non_unique | Key_name | Seq_in_index | Column_name | 
 +---------+------------+----------+--------------+-------------+ 
 | student |          0 | PRIMARY  |            1 | studentID   | 
 +---------+------------+----------+--------------+-------------+ 
 1 row in set (0.00 sec) (some columns removed on the right for clarity) 
```

### Основной и внешний ключи дочернего стола

В таблице контактных данных учащегося есть один первичный ключ, который также является идентификатором studentID. Это связано с тем, что между двумя таблицами существует взаимно однозначная взаимосвязь. Другими словами, мы ожидаем только одного студента и одного студенческого контакта на одного студента.

```sql
SHOW index FROM `student-contact-info`; 
```

```text
+----------------------+------------+----------+--------------+-------------+ 
 | Table                | Non_unique | Key_name | Seq_in_index | Column_name | 
 +----------------------+------------+----------+--------------+-------------+ 
 | student-contact-info |          0 | PRIMARY  |            1 | studentID   | 
 +----------------------+------------+----------+--------------+-------------+ 
 1 row in set (0.00 sec) (some columns removed on the right for clarity) 
```

```sql
SELECT concat(table_name, '.', column_name) AS 'foreign key', 
 concat(referenced_table_name, '.', referenced_column_name) AS 'references' 
 FROM information_schema.key_column_usage 
 WHERE referenced_table_name IS NOT NULL 
 AND table_schema = 'fcc_sql_guides_database' 
 AND table_name = 'student-contact-info'; 
```

```text
+--------------------------------+-------------------+ 
 | foreign key                    | references        | 
 +--------------------------------+-------------------+ 
 | student-contact-info.studentID | student.studentID | 
 +--------------------------------+-------------------+ 
 1 row in set (0.00 sec) 
```

### Пример отчета с использованием родительской таблицы ученика и контактной дочерней таблицы

```sql
SELECT a.studentID, a.FullName, a.programOfStudy, 
 b.`student-phone-cell`, b.`student-US-zipcode` 
 FROM student AS a 
 JOIN `student-contact-info` AS b ON a.studentID = b.studentID; 
```

```text
+-----------+------------------------+------------------+--------------------+--------------------+ 
 | studentID | FullName               | programOfStudy   | student-phone-cell | student-US-zipcode | 
 +-----------+------------------------+------------------+--------------------+--------------------+ 
 |         1 | Monique Davis          | Literature       | 555-555-5551       |              97111 | 
 |         2 | Teri Gutierrez         | Programming      | 555-555-5552       |              97112 | 
 |         3 | Spencer Pautier        | Programming      | 555-555-5553       |              97113 | 
 |         4 | Louis Ramsey           | Programming      | 555-555-5554       |              97114 | 
 |         5 | Alvin Greene           | Programming      | 555-555-5555       |              97115 | 
 |         6 | Sophie Freeman         | Programming      | 555-555-5556       |              97116 | 
 |         7 | Edgar Frank "Ted" Codd | Computer Science | 555-555-5557       |              97117 | 
 |         8 | Donald D. Chamberlin   | Computer Science | 555-555-5558       |              97118 | 
 +-----------+------------------------+------------------+--------------------+--------------------+ 
```

### Вывод

Внешние ограничения ключей - отличный инструмент для обеспечения целостности данных. Потратьте время, чтобы изучить их хорошо.

Как и для всех этих SQL-вещей, MUCH MORE им больше, чем в этом вводном руководстве.

Надеюсь, это, по крайней мере, даст вам достаточно, чтобы начать.

Пожалуйста, ознакомьтесь с руководством для своего менеджера баз данных и получайте удовольствие от различных вариантов.