---
title: SQL General Data Types
localeTitle: Общие типы данных SQL
---
## Общие типы данных SQL

# Типы данных SQL

Каждый столбец в таблице базы данных должен иметь имя и тип данных.

Разработчик SQL должен решить, какой тип данных будет храниться внутри каждого столбца при создании таблицы. Тип данных является ориентиром для SQL, чтобы понять, какой тип данных ожидается внутри каждого столбца, а также определяет, как SQL будет взаимодействовать с сохраненными данными.

# Типы данных MySQL

SQL общие типы данных состоят из следующего:

1.  Текстовое и / или числовое значение, часто называемое STRING
2.  Числовое значение, часто называемое INTEGER
3.  Календарное и / или основанное на часах значение, часто обозначаемое как DATE или TIME
4.  Значение, специфичное для базы данных, такое как флаг boolean (two-option), массив, который хранит несколько значений в одной точке данных

## Типы текстовых данных:

| Тип данных | Описание | | ------------- |: -------------: | | CHAR (размер) | Удерживает строку фиксированной длины (может содержать буквы, цифры и специальные символы). Фиксированный размер указан в скобках. Может хранить до 255 символов | | VARCHAR (размер) | Удерживает строку переменной длины (может содержать буквы, цифры и специальные символы). Максимальный размер указан в скобках. Может хранить до 255 символов. Примечание. Если вы ставите большее значение, чем 255, оно будет преобразовано в тип TEXT | | TINYTEXT | Удерживает строку длиной не более 255 символов | | ТЕКСТ | Удерживает строку с максимальной длиной 65535 символов | | BLOB | Для BLOB (Binary Large OBjects). Сохраняет до 65 535 байт данных | | MEDIUMTEXT | Удерживает строку с максимальной длиной 16,777,215 символов | | MEDIUMBLOB | Для BLOB (Binary Large OBjects). Удерживает до 16 777 215 байт данных | | LONGTEXT | Удерживает строку с максимальной длиной 4 294 967 295 символов | | LONGBLOB | Для BLOB (Binary Large OBjects). Сохраняет до 4 294 967 295 байтов данных | | ENUM (x, y, z и т. Д.) | Позвольте ввести список возможных значений. Вы можете перечислить до 65535 значений в списке ENUM. Если вставлено значение, которое отсутствует в списке, будет добавлено пустое значение. Примечание. Значения сортируются в том порядке, в котором вы их вводите. Вы вводите возможные значения в этом формате: ENUM ('X', 'Y', 'Z') | | SET | Подобно ENUM, за исключением того, что SET может содержать до 64 элементов списка и может хранить более одного выбора |

# Количество типов данных:

| Тип данных | Описание | | ------------- |: -------------: | | TINYINT (размер) | От -128 до 127. От 0 до 255 UNSIGNED _. Максимальное количество цифр может быть указано в скобках | | SMALLINT (размер) | -32768 до 32767 нормально. 0 до 65535 НЕОГРАНИЧЕН_ . Максимальное количество цифр может быть указано в скобках | | MEDIUMINT (размер) | -8388608 до 8388607 нормально. 0 до 16777215 НЕ ПОДЛЕЖИТ _. Максимальное количество цифр может быть указано в скобках | | INT (размер) | -2147483648 до 2147483647 нормальный. 0 до 4294967295 НЕОГРАНИЧЕН_ . Максимальное количество цифр может быть указано в скобках | | BIGINT (размер) | -9223372036854775808 до 9223372036854775807 обычный. 0 до 18446744073709551615 UNSIGNED \*. Максимальное количество цифр может быть указано в скобках | | FLOAT (размер, г) | Небольшое число с плавающей запятой. Максимальное количество цифр может быть указано в параметре размера. Максимальное количество цифр справа от десятичной точки указано в параметре d | | DOUBLE (размер, г) | Большое число с плавающей запятой. Максимальное количество цифр может быть указано в параметре размера. Максимальное количество цифр справа от десятичной точки указано в параметре d | | DECIMAL (размер, г) | ДВОЙНА хранится как строка, позволяющая фиксированную десятичную точку. Максимальное количество цифр может быть указано в параметре размера. Максимальное количество цифр справа от десятичной точки указано в параметре d |

# Типы данных даты:

| Тип данных | Описание | | ------------- |: -------------: | | DATE () | Свидание. Формат: ГГГГ-ММ-ДД Примечание. Поддерживаемый диапазон: от «1000-01-01» до «9999-12-31» | | DATETIME () | Комбинация даты и времени. Формат: ГГГГ-ММ-ДД ЧЧ: МИ: СС Примечание: поддерживаемый диапазон от «1000-01-01 00:00:00» до «9999-12-31 23:59:59» | | TIMESTAMP () | Временная метка. Значения TIMESTAMP сохраняются как количество секунд с момента Unix ('1970-01-01 00:00:00' UTC). Формат: ГГГГ-ММ-ДД HH: MI: SS Примечание: Поддерживаемый диапазон: '1970-01-01 00:00:01' UTC to '2038-01-09 03:14:07' UTC | | TIME () | Время. Формат: HH: MI: SS Примечание: Поддерживаемый диапазон составляет от -838: 59: 59 'до' 838: 59: 59 '| | ГОД () | Год в двухзначном или четырехзначном формате. Примечание. Значения разрешены в четырехзначном формате: от 1901 до 2155. Значения разрешены в двузначном формате: от 70 до 69, представляя годы от 1970 до 2069 |

#### Дополнительная информация:

Более подробную информацию о конкретных типах данных в SQL можно найти в разделе « [Типы данных SQL](https://guide.freecodecamp.org/sql/sql-data-types/) » в файле freeCodeCamp.