---
title: SQL Order By Keyword
localeTitle: SQL-запрос по ключевому слову
---
## SQL-запрос по ключевому слову

### Заказ по (ASC, DESC)

ORDER BY дает нам способ СОРТИРОВАТЬ набор результатов одним или несколькими элементами в секции SELECT. Вот SQL, сортировка студентов по FullName в порядке убывания. Сортировка по умолчанию возрастает (ASC), но для сортировки в обратном порядке (по убыванию) используется DESC.

```sql
SELECT studentID, FullName, sat_score 
 FROM student 
 ORDER BY FullName DESC; 
```

```text
+-----------+------------------------+-----------+ 
 | studentID | FullName               | sat_score | 
 +-----------+------------------------+-----------+ 
 |         2 | Teri Gutierrez         |       800 | 
 |         3 | Spencer Pautier        |      1000 | 
 |         6 | Sophie Freeman         |      1200 | 
 |         9 | Raymond F. Boyce       |      2400 | 
 |         1 | Monique Davis          |       400 | 
 |         4 | Louis Ramsey           |      1200 | 
 |         7 | Edgar Frank "Ted" Codd |      2400 | 
 |         8 | Donald D. Chamberlin   |      2400 | 
 |         5 | Alvin Greene           |      1200 | 
 +-----------+------------------------+-----------+ 
 9 rows in set (0.00 sec) 
```

_Вот список UN-ORDERED, текущий, полный список студентов, чтобы сравнить с вышесказанным._

```sql
SELECT studentID, FullName, sat_score, rcd_updated FROM student; 
```

```text
+-----------+------------------------+-----------+---------------------+ 
 | studentID | FullName               | sat_score | rcd_updated         | 
 +-----------+------------------------+-----------+---------------------+ 
 |         1 | Monique Davis          |       400 | 2017-08-16 15:34:50 | 
 |         2 | Teri Gutierrez         |       800 | 2017-08-16 15:34:50 | 
 |         3 | Spencer Pautier        |      1000 | 2017-08-16 15:34:50 | 
 |         4 | Louis Ramsey           |      1200 | 2017-08-16 15:34:50 | 
 |         5 | Alvin Greene           |      1200 | 2017-08-16 15:34:50 | 
 |         6 | Sophie Freeman         |      1200 | 2017-08-16 15:34:50 | 
 |         7 | Edgar Frank "Ted" Codd |      2400 | 2017-08-16 15:35:33 | 
 |         8 | Donald D. Chamberlin   |      2400 | 2017-08-16 15:35:33 | 
 |         9 | Raymond F. Boyce       |      2400 | 2017-08-16 15:35:33 | 
 +-----------+------------------------+-----------+---------------------+ 
 9 rows in set (0.00 sec) 
```

Как и для всех этих SQL-вещей, MUCH MORE им больше, чем в этом вводном руководстве.

Надеюсь, это, по крайней мере, даст вам достаточно, чтобы начать.

Пожалуйста, ознакомьтесь с руководством для своего менеджера баз данных и получайте удовольствие от различных вариантов.