---
title: SQL Primary Key Constraint
localeTitle: Ограничение основного ключа SQL
---
## Первичное ограничение ключа

### Введение

Первичный ключ - это столбец или набор столбцов, которые однозначно идентифицируют каждую строку в таблице.

Он называется «ограничение», потому что он заставляет систему ограничивать данные, разрешенные в этих столбцах. В этом случае….

*   для хранения данных (NOT NULL)
*   УНИКАЛЬНО из всех остальных строк таблицы.
*   Каждая таблица может иметь только ОДИН первичный ключ

Первичные ключи в основном используются для поддержания целостности данных каждой строки.

Это также позволяет системе и приложениям убедиться, что они правильно считывают, обновляют и соединяют данные.

### Пример с созданием таблицы

Вот команда create table, которая также создаст первичный ключ, используя два поля.

```sql
CREATE TABLE priKeyExample( 
 rcdKey_id_a INT NOT NULL, 
 rcdKeySeq_id INT NOT NULL, 
 someData varchar(256) NOT NULL, 
 PRIMARY KEY(rcdKey_id_a,rcdKeySeq_id)); 
```

### Пример с альтернативной таблицей

Существующий должен быть удален первым

```sql
DROP INDEX `primary` ON priKeyExample; 
```

Теперь мы добавим новый.

```sql
ALTER TABLE priKeyExample 
 ADD CONSTRAINT myPriKey PRIMARY KEY(rcdKey_id_a,rcdKeySeq_id); 
```

Как и для всех этих SQL-вещей, MUCH MORE им больше, чем в этом вводном руководстве.

Надеюсь, это, по крайней мере, даст вам достаточно, чтобы начать.

Пожалуйста, ознакомьтесь с руководством для своего менеджера баз данных и получайте удовольствие от различных вариантов.