---
title: SQL Syntax
localeTitle: Синтаксис SQL
---
## Синтаксис SQL

### Введение

В этом руководстве представлено базовое, высокоуровневое описание синтаксиса для операторов SQL.

SQL - это международный стандарт (ISO), но вы найдете много различий между реализациями. В этом руководстве в качестве примера используется MySQL. Если вы используете один из многих других реляционных менеджеров баз данных (СУБД), вам нужно будет проверить руководство для этой СУБД, если это необходимо.

### Что мы рассмотрим

*   Используйте (устанавливает, какую базу данных будет использовать оператор)
*   Выделение и из предложений
*   Где пункт (и / или, IN, Between, LIKE)
*   Заказ по (ASC, DESC)
*   Группировка и наличие

### Как использовать это

Это используется для выбора базы данных, содержащей таблицы для ваших операторов SQL:

```sql
use fcc_sql_guides_database; -- select the guide sample database 
```

### Выделение и из предложений

Часть выбора обычно используется для определения столбцов данных, которые вы хотите отображать в результатах. Существуют также варианты, которые вы можете использовать для отображения данных, которые не являются столбцами таблицы.

В этом примере показаны два столбца, выбранных из таблицы «ученик» и двух вычисленных столбцов. Первый из вычисленных столбцов - это бессмысленное число, а другое - системная дата.

```sql
    select studentID, FullName, 3+2 as five, now() as currentDate 
    from student; 
```

![Изображение-1](https://github.com/SteveChevalier/guide-images/blob/master/syntax01.JPG)

### Где пункт (и / или, IN, Between и LIKE)

Предложение WHERE используется для ограничения количества возвращаемых строк.

В этом случае все пять из них будут использованы, это несколько смешное предложение Where.

Сравните этот результат с приведенной выше операцией SQL, чтобы следовать этой логике.

Строки будут представлены следующим образом:

*   Имеют идентификаторы учащихся от 1 до 5 (включительно)
*   или studentID = 8
*   или иметь «Maxmimo» в названии

Следующий пример аналогичен, но он далее указывает, что если у любого из учеников есть определенные баллы SAT (1000, 1400), они не будут представлены:

```sql
    select studentID, FullName, sat_score, recordUpdated 
    from student 
    where ( 
        studentID between 1 and 5 
        or studentID = 8 
        or FullName like '%Maximo%' 
        ) 
        and sat_score NOT in (1000, 1400); 
```

![Изображение-1](https://github.com/SteveChevalier/guide-images/blob/master/syntax02.JPG)

### Заказ по (ASC, DESC)

Order By дает нам способ сортировки результирующего набора одним или несколькими элементами в секции SELECT. Ниже приведен список, указанный выше, но отсортированный по имени полного имени студентов. Порядок сортировки по умолчанию возрастает (ASC), но для сортировки в обратном порядке (по убыванию) вы используете DESC, как в примере ниже:

```sql
    select studentID, FullName, sat_score 
    from student 
    where (studentID between 1 and 5 -- inclusive 
        or studentID = 8 
        or FullName like '%Maximo%') 
        and sat_score NOT in (1000, 1400) 
    order by FullName DESC; 
```

![Изображение-1](https://github.com/SteveChevalier/guide-images/blob/master/syntax03.JPG)

### Группировка и наличие

Group By дает нам способ комбинировать строки и агрегированные данные. Предложение «Бытие» похоже на вышеприведенное предложение Where, за исключением того, что оно действует на сгруппированные данные.

Эти данные взяты из данных о взносах кампании, которые мы использовали в некоторых из этих руководств.

Этот SQL-запрос отвечает на вопрос: «Какие кандидаты получили наибольшее количество взносов (не $ amount, а count (\*)) в 2016 году, а только те, у кого было более 80 вкладов?»

Заказ этого набора данных в порядке убывания (DESC) помещает кандидатов с наибольшим количеством вкладов в верхней части списка.

```sql
    select Candidate, Election_year, sum(Total_$), count(*) 
    from combined_party_data 
    where Election_year = 2016 
    group by Candidate, Election_year 
    having count(*) > 80 
    order by count(*) DESC; 
```

![Изображение-1](https://github.com/SteveChevalier/guide-images/blob/master/syntax04.JPG)

_Как и для всех этих SQL-вещей, MUCH MORE им больше, чем в этом вводном руководстве. Надеюсь, это, по крайней мере, даст вам достаточно, чтобы начать. Пожалуйста, ознакомьтесь с руководством для своего менеджера баз данных и получайте удовольствие от различных вариантов._