---
title: SQL Where Clause
localeTitle: Предложение SQL Where
---
## Предложение SQL Where

### `WHERE` (и / или, `IN` , `BETWEEN` и `LIKE` )

Предложение `WHERE` используется для ограничения количества возвращаемых строк.

В этом случае все пять из них будут использованы, это какое-то смешное `WHERE` .

Вот текущий полный список студентов для сравнения с набором результатов предложения `WHERE` :

```sql
select studentID, FullName, sat_score, rcd_updated from student; 
```

```text
+-----------+------------------------+-----------+---------------------+ 
 | studentID | FullName               | sat_score | rcd_updated         | 
 +-----------+------------------------+-----------+---------------------+ 
 |         1 | Monique Davis          |       400 | 2017-08-16 15:34:50 | 
 |         2 | Teri Gutierrez         |       800 | 2017-08-16 15:34:50 | 
 |         3 | Spencer Pautier        |      1000 | 2017-08-16 15:34:50 | 
 |         4 | Louis Ramsey           |      1200 | 2017-08-16 15:34:50 | 
 |         5 | Alvin Greene           |      1200 | 2017-08-16 15:34:50 | 
 |         6 | Sophie Freeman         |      1200 | 2017-08-16 15:34:50 | 
 |         7 | Edgar Frank "Ted" Codd |      2400 | 2017-08-16 15:35:33 | 
 |         8 | Donald D. Chamberlin   |      2400 | 2017-08-16 15:35:33 | 
 |         9 | Raymond F. Boyce       |      2400 | 2017-08-16 15:35:33 | 
 +-----------+------------------------+-----------+---------------------+ 
 9 rows in set (0.00 sec) 
```

Строки будут представлены, что ....

*   `WHERE` Идентификаторы учащихся составляют от 1 до 5 (включительно)
*   `OR` studentID = 8

Ниже приведен обновленный запрос, в котором не будет представлена ​​любая запись с оценкой SAT, которая находится в этом списке (1000, 1400):

```sql
select  studentID, FullName, sat_score, recordUpdated 
 from    student 
 where   (studentID between 1 and 5 or studentID = 8) 
        and 
        sat_score NOT in (1000, 1400); 
```

```text
+-----------+----------------------+-----------+---------------------+ 
 | studentID | FullName             | sat_score | rcd_updated         | 
 +-----------+----------------------+-----------+---------------------+ 
 |         1 | Monique Davis        |       400 | 2017-08-16 15:34:50 | 
 |         2 | Teri Gutierrez       |       800 | 2017-08-16 15:34:50 | 
 |         4 | Louis Ramsey         |      1200 | 2017-08-16 15:34:50 | 
 |         5 | Alvin Greene         |      1200 | 2017-08-16 15:34:50 | 
 |         8 | Donald D. Chamberlin |      2400 | 2017-08-16 15:35:33 | 
 +-----------+----------------------+-----------+---------------------+ 
 5 rows in set (0.00 sec) 
```

\* Как и все эти SQL-вещи, им гораздо БОЛЬШЕ, чем тому, что находится в этом вводном руководстве.

Надеюсь, это, по крайней мере, даст вам достаточно, чтобы начать.

Пожалуйста, ознакомьтесь с руководством для своего менеджера баз данных и получайте удовольствие от различных вариантов.