---
title: Managing multiple SSH keys
localeTitle: Управление несколькими SSH-ключами
---
# Управление несколькими SSH-ключами

Можно с уверенностью сказать, что большинство разработчиков в веб-сфере в какой-то момент столкнулись с SSH. SSH является одним из наиболее часто используемых протоколов для безопасного обмена данными. Вы используете SSH для подключения к удаленным серверам, который также включает управление вашим кодом с помощью git и синхронизацию с удаленными репозиториями.

Несмотря на то, что считается хорошей практикой иметь одну частную пару с открытым ключом на устройство, иногда вам нужно использовать несколько ключей и / или у вас есть неортодоксальные имена ключей. Возможно, вы используете одну пару ключей SSH для работы над внутренними проектами своей компании, но вы можете использовать другой ключ для доступа к серверам некоторых корпоративных клиентов. Возможно, вы даже используете другой ключ для доступа к вашему собственному частному серверу.

Управление ключами SSH может стать громоздким, как только вам понадобится использовать второй ключ. Я надеюсь, что эта статья будет полезной для всех, кто сталкивается с управлением ключами SSH.

Я полагаю, что у читателя есть базовые знания о git и SSH. Большинство примеров на протяжении всей статьи будут использовать git. Конечно, все это будет применяться к любому другому сообщению SSH. Это, как говорится, есть некоторые git-специфические трюки, включенные.

Вставьте сюда, вот и мы!

## Статус кво

Во-первых, давайте посмотрим, как выглядит ваш рабочий процесс, прежде чем вам придется беспокоиться о нескольких ключах.

У вас есть один закрытый ключ, хранящийся в `~/.ssh/id_rsa` с соответствующим открытым ключом `~/.ssh/id_rsa.pub` .

Представим себе, что вы хотите нажимать / вытаскивать изменения кода на / с удаленного сервера git; скажем, GitHub, whynot. Для этого сначала нужно добавить свой открытый ключ в GitHub. Я не буду проходить этот шаг, должно быть достаточно легко узнать, как это сделать. Я также предположил, что ваше имя - Стив, и вы работаете над сверхсекретным проектом, который использует малиновый пирог, чтобы обнюхать сетевой трафик.

Чтобы начать работу, вы должны клонировать репозиторий git с помощью SSH:

```bash
git clone git@github.com:steve/raspberry-spy.git 
```

В этот момент GitHub будет выглядеть так: «Yo, это частный репозиторий! Нам нужно зашифровать трафик, используя этот открытый ключ, который у меня есть, и ваш закрытый ключ»

Вы добавили открытый ключ в свой профиль на GitHub, но SSH должен как-то выяснить, где находится ваш соответствующий секретный ключ. Поскольку мы не знаем, какой секретный ключ следует использовать при SSH-ing в `git@github.com` , SSH-клиент пытается найти ключ в местоположении по умолчанию, который равен `~/.ssh/id_rsa` - это его лучшая догадка. Если в этом месте нет файла, вы получите сообщение об ошибке:

```bash
Cloning into 'raspberry-spy'... 
 Permission denied (publickey). 
 fatal: Could not read from remote repository. 
 
 Please make sure you have the correct access rights 
 and the repository exists. 
```

Если у вас _есть_ закрытый ключ , хранящийся в файле `~/.ssh/id_rsa` , SSH - клиент будет использовать этот секретный ключ для шифрования связи. Если этот ключ введен в пароль (как и должно быть), вам будет предложено ввести пароль:

```bash
Enter passphrase for key '/Users/steve/.ssh/id_rsa': 
```

Если вы введете правильную кодовую фразу и если этот секретный ключ действительно соответствует тому, который соответствует открытому ключу, который вы привязали к вашему профилю, все будет хорошо, и репозиторий будет клонирован успешно.

Но что, если вы назвали свой ключ по-другому (например, `~/.ssh/_id_rsa` )? Клиент SSH не сможет определить, где хранится секретный ключ. Как и раньше, вы получите ту же `Permission denied ...`

Если вы хотите использовать закрытый ключ, который вы назвали по-другому, вам нужно добавить его вручную:

```bash
ssh-add ~/.ssh/_id_rsa 
```

После ввода ключевой фразы вы можете проверить, был ли ключ добавлен в `ssh-agent` (клиент SSH), выполнив `ssh-add -l` . Эта команда отобразит все ключи, доступные в настоящее время для клиента SSH.

Если вы попытаетесь клонировать хранилище сейчас, оно будет успешным.

## Все идет нормально?

Если у вас острые глаза, вы можете начать замечать некоторые потенциальные проблемы.

Во-первых, если вы перезагрузите свой компьютер, `ssh-agent` перезапустится, и вам придется добавлять свои ключи без имени по умолчанию, используя `ssh-add` снова и снова, вводя пароли и все эти утомительные вещи.

Можем ли мы автоматизировать добавление ключей или каким-то образом указать, какой ключ использовать при доступе к определенным серверам?

Можем ли мы каким-то образом сохранить пароли, поэтому нам не нужно вводить их каждый раз? Если бы существовало нечто вроде _брелка_ для сохранения защищенных паролем SSH-ключей 🤔.

Будьте уверены, есть ответы на все эти вопросы.

## Ввод, `config` SSH

Как оказалось, [файл конфигурации SSH](https://linux.die.net/man/5/ssh_config) - это вещь, которая может помочь нам. Это файл конфигурации для пользователя для связи SSH. Создайте новый файл: `~/.ssh/config` и откройте его для редактирования.

### Управление подзаголовными ключами SSH

Первое, что мы собираемся решить с помощью этого `config` файла, - это не добавлять пользовательские SSH-ключи, используя `ssh-add` . Предполагая, что ваш SSH-ключ называется `~/.ssh/_id_rsa` , добавьте следующее в файл `config` :

```bash
Host github.com 
  HostName github.com 
  User git 
  IdentityFile ~/.ssh/_id_rsa 
  IdentitiesOnly yes 
```

Теперь убедитесь, что `~/.ssh/_id_rsa` не находится в `ssh-agent` , выполнив `ssh-add -D` . Эта команда удалит все ключи из текущего активного сеанса `ssh-agent` . Сессия сбрасывается каждый раз, когда вы выходите из системы или перезагружаетесь (или если вы вручную `ssh-agent` процесс `ssh-agent` ). Мы можем «имитировать» перезагрузку, выполнив указанную команду.

Если вы попытаетесь клонировать ваш репозиторий GitHub, то он будет таким же, как если бы мы добавили ключ вручную (как и раньше). Вам будет предложено ввести пароль:

```bash
git clone git@github.com:steve/raspberry-spy.git 
 Cloning into 'raspberry-spy'... 
 Enter passphrase for key '/Users/steve/.ssh/_id_rsa': 
```

Вы заметили, что ключ, для которого мы запрашиваем пароль, - это тот же ключ, который мы указали в нашем файле `config` . После ввода правильного пароля ключа SSH репозиторий будет успешно клонирован.

Примечание: если после успешного клонирования вы попытаетесь выполнить `git pull` , вам снова будет предложено ввести пароль. Мы это решим позже.

Важно, чтобы `Host github.com` из `config` и `github.com` из URI `git@github.com:steve/raspberry-spy.git` . Вы также можете изменить `config` для `Host mygithub` и клона, используя URI `git@mygithub:steve/raspberry-spy.git` .

Это открывает шлюзы. Когда вы это делаете, ваш ум мчится и думает о том, как все ваши проблемы с ключами SSH закончены. Вот несколько полезных примеров конфигурации:

```bash
Host bitbucket-corporate 
        HostName bitbucket.org 
        User git 
        IdentityFile ~/.ssh/id_rsa_corp 
        IdentitiesOnly yes 
```

Теперь вы можете использовать `git clone git@bitbucket-corporate:company/project.git`

```bash
Host bitbucket-personal 
        HostName bitbucket.org 
        User git 
        IdentityFile ~/.ssh/id_rsa_personal 
        IdentitiesOnly yes 
```

Теперь вы можете использовать `git clone git@bitbucket-personal:steve/other-pi-project.git`
```
Host myserver 
        HostName ssh.steve.com 
        Port 1111 
        IdentityFile ~/.ssh/id_rsa_personal 
        IdentitiesOnly yes 
        User steve 
        IdentitiesOnly yes 
```

Теперь вы можете использовать SSH на своем сервере с помощью `ssh myserver` . Как это круто? Вам не нужно вводить порт и имя пользователя вручную каждый раз, когда вы выполняете команду `ssh` .

#### Бонус: настройки для репозитория

Вы также можете определить, какой конкретный ключ следует использовать для определенного репозитория, переопределяя что-либо в `config` SSH. Конкретную команду SSH можно определить, установив `sshCommand` под `core` в `<project>/.git/config` . Пример:

```bash
[core] 
        sshCommand = ssh -i ~/.ssh/id_rsa_corp 
```

Это возможно с git 2.10 или новее. Вы также можете использовать эту команду, чтобы избежать редактирования файла вручную:

```bash
git config core.sshCommand 'ssh -i ~/.ssh/id_rsa_corp' 
```

### Управление паролями

Последняя часть головоломки управляет паролями. Мы хотим избежать необходимости вводить пароль каждый раз при запуске соединения SSH. Для этого мы можем использовать программное обеспечение для управления ключами, которое поставляется с MacOS и различными дистрибутивами Linux.

Начните с добавления ключа в цепочку ключей путем передачи опции `-K` команде `ssh-add` :

```bash
ssh-add -K ~/.ssh/id_rsa_whatever 
```

Теперь вы можете увидеть свой SSH-ключ в цепочке ключей. В MacOS это выглядит примерно так: ![Keychain Access](https://raw.githubusercontent.com/fvoska/guides/master/static/images/pages/ssh/managing-multiple-ssh-keys/keychain-access.png "Доступ к брелкам")

Если вы удалите ключи из `ssh-agent` через `ssh-add -D` (это произойдет, когда вы перезагрузите компьютер, как упоминалось ранее) и попробуйте SSH-ing, вам снова будет предложено ввести пароль. Зачем? Мы просто добавили ключ к цепочке ключей. Если вы снова проверите Keychain Access, вы заметите, что ключ, добавленный с помощью `ssh-add -K` , все еще находится в цепочке ключей. Странно, да?

Оказывается, есть еще один обруч, чтобы проскочить. Откройте `config` файл SSH и добавьте следующее:

```bash
Host * 
  AddKeysToAgent yes 
  UseKeychain yes 
```

Теперь SSH будет искать ключ в цепочке ключей, и если он найдет его, вам не будет предложено ввести пароль. Ключ также будет добавлен в `ssh-agent` . В MacOS это будет работать на MacOS Sierra 10.12.2 или новее. В Linux вы можете использовать что-то вроде `gnome-keyring` и оно может работать даже без последней модификации `config` SSH. Что касается Windows - кто знает, не так ли?

Надеюсь, кто-то нашел это полезным. Теперь перейдите и настройте свой `config` файл SSH!