---
title: SVG
localeTitle: SVG
---
## SVG

SVG или масштабируемая векторная графика - это веб-стандарт для определения векторной графики на веб-страницах. На основе XML стандарт SVG обеспечивает разметку для описания путей, форм и текста в окне просмотра. Разметка может быть встроена непосредственно в HTML для отображения или сохранена в `.svg` файле и вставлена ​​как любое другое изображение. Вы можете писать SVG вручную, но более сложная графика может быть сконструирована в редакторах векторной графики, таких как Illustrator или InkScape, и экспортируется в файлы SVG или код.

## Основы SVG

Разработчики запускают SVG-графику с `<svg>` и пространством имен XML следующим образом:

```svg
<svg xmlns="http://www.w3.org/2000/svg" version="1.1"> 
 
 </svg> 
```

Образец также включает атрибут `version` . Атрибут `version` является необязательным, но рекомендуется для удовлетворения требований XML.

Этот образец ничего не отобразит, он просто установил окно просмотра. Вы можете добавить атрибуты `height` и `width` чтобы установить размер отображения для окна просмотра, что существенно упрощает работу с вами.

С помощью видового экрана вы можете добавить основные элементы графики, текста и пути.

```svg
<svg 
     version="1.1" 
     width="100%" 
     viewbox="0 0 600 300" 
     xmlns="http://www.w3.org/2000/svg"> 
  <rect x="10" y="10" width="100" height="100" fill="#f7b2c1" /> 
  <circle cx="240" cy="60" r="50" fill="#c1b2f7" stroke="#b2c1f7" stroke-width="15"/> 
  <text x="450" y="70" font-size="20" text-anchor="middle">SVG Text is browser readable!</text> 
  <g stroke="#b2c1f7"> <!-- g is for group --> 
    <path stroke-width="2" d="M10 170 l590 0" /> 
    <path stroke-width="4" d="M10 190 l590 0" /> 
    <path stroke-width="6" d="M10 210 l590 0" /> 
  </g> 
 </svg> 
```

Вы можете видеть вывод и играть с кодом в [этом кодефене](https://codepen.io/SgiobairOg/pen/OxbNpW) .

В открывшемся теге `svg` мы добавляем атрибут width, чтобы установить ширину окна просмотра на 100% ширины контейнера, вы можете использовать проценты или ширину пикселей. В открывшемся теге svg также есть атрибут `viewbox` который определяет окно, через которое видны элементы вашего svg, в этом случае окно просмотра охватывает от (0,0) до (600,300). В пространстве SVG ось X начинается с нуля слева и увеличивается вправо; ось Y начинается с нуля вверху и увеличивается к дну.

Первый новый тег - тег `<rect />` который определяет прямоугольник в окне SVG. В этом случае мы определяем квадрат, который составляет 10 единиц сверху и слева и 100 единиц в высоту и ширину. Атрибут `fill` устанавливает цвет заливки для фигуры.

Затем мы определяем круг или овал с `<circle />` . Образец определяет круг с центром в (240,60) с радиусом 50 единиц. Атрибуты `stroke` и `stroke-width` задают цвет хода и размер для штриха.

Вы можете добавить текст к графике с помощью `text` тега. Пример текста привязан от середины текста до точки (450, 70) и имеет размер шрифта 20 единиц. Хорошая вещь о тексте в SVG будет масштабироваться с остальной частью вашей графики, но она по-прежнему читается браузером и веб-ботами.

Если вы хотите применить те же атрибуты или стили CSS к нескольким элементам SVG, вы можете сгруппировать их с `<g>` . Атрибуты, назначенные тегу `<g>` , как и атрибут `stroke` в примере, будут применены ко всем элементам группы. В этом случае три элемента `<path />` .

Элемент `<path />` определяет векторный путь в окне просмотра. Путь определяется атрибутом `d` . В первом примере определение читает «переместится в абсолютную координату (10, 170) _и_ нарисует линию на относительные координаты 590 в направлении X и 0 в направлении Y.

Для создания вашего пути можно использовать следующие команды:

M = перейти к L = строка для H = горизонтальная линия до V = вертикальная линия до Z = закрыть путь C = (кубическая безье) кривая к S = гладкая кривая к Q = квадратичная кривая Безье для T = гладкая квадратичная кривая Безье для A = дуга

### Элемент холста

Графика холста может быть нарисована на

элемент. Вы можете указать такие атрибуты ширины и высоты элемента, чтобы определить его размер в пикселях. Новый холст пуст, что означает, что он полностью прозрачен и просто опущен просто как пустое место в документе.

тег предназначен для поддержки разных стилей рисования. Чтобы получить доступ к реальному интерфейсу рисования, нам сначала нужно создать контекст, который является объектом, методы которого предоставляют интерфейс рисования. В настоящее время существуют два широко поддерживаемых стиля рисования: «2d», для двумерной графики и «webgl» для трехмерной графики через интерфейс OpenGL.

Контекст создается методом getContext на

элемент.
```
<p > Before canvas . </p > 
 < canvas width ="120" height ="60" > </ canvas > 
 <p > After canvas . </p > 
 < script > 
 var canvas = document . querySelector (" canvas ") ; 
 var context = canvas . getContext ("2 d ") ; 
 context . fillStyle = " red "; 
 context . fillRect (10 , 10 , 100 , 50) ; 
 </ script > 
```

![](http://www.crwflags.com/fotw/images/s/sly@stt.gif)

После создания объекта контекста, пример рисует красный прямоугольник 100 пикселей в ширину и 50 пикселей в высоту, с верхним левым углом в координатах (10,10).

### Рисование круговой диаграммы

Переменная результатов содержит массив объектов, которые представляют ответы на опросы.
```
var results = [ 
 { name : " Satisfied " , count : 1043 , color : " lightblue "} , 
 { name : " Neutral " , count : 563 , color : " lightgreen "} , 
 { name : " Unsatisfied " , count : 510 , color : " pink "} , 
 { name : " No comment " , count : 175 , color : " silver "} 
 ]; 
```

Чтобы нарисовать круговую диаграмму, мы рисуем несколько кусочков пирога, каждый из которых состоит из дуги и пары линий к центру этой дуги. Мы можем вычислить угол, поглощаемый каждой дугой, путем деления полного круга (2 π) на общее число ответов и затем умножения этого числа (угол за ответ) на количество людей, которые выбрали данный выбор.
```
< canvas width ="200" height ="200" > </ canvas > 
 < script > 
 var cx = document . querySelector (" canvas ") . getContext ("2 d ") ; 
 var total = results . reduce ( function ( sum , choice ) { 
 return sum + choice . count ; 
 } , 0) ; 
 
 // Start at the top 
 
 var currentAngle = -0.5 * Math . PI ; 
 results . forEach ( function ( result ) { 
 var sliceAngle = ( result . count / total ) * 2 * Math . PI ; 
 cx . beginPath () ; 
 // center =100 ,100 , radius =100 
 // from current angle , clockwise by slice ' s angle 
 cx . arc (100 , 100 , 100 , 
 currentAngle , currentAngle + sliceAngle ); 
 currentAngle += sliceAngle ; 
 cx . lineTo (100 , 100) ; 
 cx . fillStyle = result . color ; 
 cx . fill () ; 
 }) ; 
 </ script > 
```

Это рисует следующий график: ![](https://pbs.twimg.com/media/CTDvkA8UwAAdJg5.png)

### Поддержка браузера

[Поддержка браузера для SVG](https://caniuse.com/#feat=svg) доступна во всех современных браузерах. Есть некоторые проблемы с масштабированием в IE 9 через IE 11, однако их можно преодолеть с помощью `width` , `height` , `viewbox` и CSS.

## редакторы

*   [Vectr](https://vectr.com) - веб-и настольный инструмент для создания и редактирования графики SVG, бесплатно

## Инструменты для создания SVG

Существует несколько инструментов для создания SVG в виде программы рисования.

*   [Inkscape](https://www.inkscape.org/) - это инструмент с открытым исходным кодом для современного векторного рисования с простым графическим интерфейсом.
*   [Adobe Illustrator](https://www.adobe.com/products/illustrator/) - Adobe Illustrator - это коммерческий инструмент для Vector Imagery.

Дополнительные инструменты см. В [списке инструментов W3C, поддерживающих SVG](https://https://www.w3.org/Graphics/SVG/WG/wiki/Implementations)

## Почему вы должны использовать SVG

В качестве формата векторного изображения он позволяет изменять размер изображения без потери качества и особенно легкого веса. Как формат XML, он позволяет вам использовать всю мощь JavaScript и особенно CSS.

## Ресурсы

*   [W3C, масштабируемая векторная графика (SVG) 1.1 (второе издание)](https://www.w3.org/TR/SVG/)
*   [Mozilla Developer Network, SVG](https://developer.mozilla.org/en-US/docs/Web/SVG)