---
title: SVG Shapes
localeTitle: SVG Shapes
---
## SVG Shapes

С помощью SVG можно создавать несколько форм. Чертеж SVG может использовать и объединять семь фигур: Путь, Прямоугольник, Круг, Эллипс, Линия, Полилиния и Многоугольник.

### Дорожка

Элемент `path` является наиболее часто встречающимся и обычно генерируется программами, предназначенными для экспорта SVG-кода.

```svg
  <path d="M2 1 h1 v1 h1 v1 h-1 v1 h-1 v-1 h-1 v-1 h1 z" /> 
```

В приведенном выше примере `path` генерирует символ «плюс» (+) при использовании внутри чертежа SVG. Элементы `path` SVG не создаются вручную, а сгенерированы с помощью программ проектирования, которые могут манипулировать векторной графикой, например Illustrator или Inkscape.

### Прямоугольник

Прямоугольник `rect` рисует прямоугольник на экране и принимает шесть атрибутов.

```svg
  <rect x="0" y="0" width="100" height="50" rx="10" ry="10" /> 
```

`x` и `y` назначают положение верхнего левого угла прямоугольника, а `width` и `height` определяют размер прямоугольника. `rx` и `ry` назначают радиус углов прямоугольника, аналогично свойству CSS border-radius.

### Круг

Круг элемент `circle` принимает три атрибута.

```svg
  <circle cx="100" cy="100" r="50" /> 
```

`cx` и `cy` назначают положение центра круга, а `r` присваивает радиус (размер) круга.

### Эллипс

Элемент эллипса, `ellipse` , подобен элементу `circle` за исключением того, что радиус делится на два атрибута.

```svg
  <ellipse cx="100" cy="100" rx="50" ry="20" /> 
```

Опять же, `cx` и `cy` назначают положение центра эллипса, а теперь `rx` и `ry` назначают горизонтальный и вертикальный радиус эллипса соответственно. Большой `rx` даст «толстый» эллипс, а более крупный `ry` даст более тонкий эллипс. Если `rx` и `ry` равны, он образует круг.

### Линия

Элемент `line` прост и принимает четыре атрибута.

```svg
  <line x1="0" x2="100" y1="50" y2="70" /> 
```

Атрибуты `x1` и `y1` назначают первую точку строки, а атрибуты `x2` и `y2` назначают вторую точку линии.

### Ломаная

`polyline` - это серия связанных прямых линий, назначенных в одном атрибуте.

```svg
  <polyline points="0 100, 50 70, 60 40, 20 0" /> 
```

Атрибут `points` присваивает список точек, каждая точка разделяется запятой.

### многоугольник

Элемент `polygon` также представляет собой серию связанных прямых линий, но в этом случае последняя строка автоматически соединяется с начальной точкой.

```svg
  <polygon points="0 100, 50 70, 60 40, 20 0" /> 
```

Этот пример будет иметь ту же форму, что и выше, чем `polyline` , но он будет нарисовать дополнительную строку, чтобы «закрыть» ряд строк.

## Больше информации

MDN Документация: [MDN](https://developer.mozilla.org/en-US/docs/Web/SVG/Tutorial/Basic_Shapes)