---
title: Swift
localeTitle: Swift
---
![Swift Logo](https://developer.apple.com/assets/elements/icons/swift-playgrounds/swift-playgrounds-64x64_2x.png)

# Что такое Swift?

Swift - это язык программирования общего назначения [с открытым исходным кодом](https://en.wikipedia.org/wiki/Open-source_software), разработанный Apple Inc. Они описывают его так:


> Swift - мощный интерактивный и интуитивно-понятный язык программирования для macOS, iOS, watchOS и tvOS. Писать на нем легко и весело. Разработчики ценят Swift за то, что в нем много современных особенностей облегчающих им жизнь. Синтаксис Swift лаконичный, но в то же время выразительный.  Код Swift безопасен по своему замыслу, но при этом производит программное обеспечение работающее молниеносно. <sup>1</sup>


Хотите попробовать Swift прямо сейчас? [Repl.it](https://repl.it/languages/swift) предлагает онлайн интерактивную среду для Swift - Read-Eval-Print loop. У вас не будет доступа к UIKit или другим API, которые обычно используются, но чем черт не шутит!

# Основы

Чтобы объявить переменную в Swift, просто используйте var, а затем назовите вашу переменную.

```Swift
var x = 6 
var name = "Bob" 
var boole = true 
 
x = 3 
```

Константы похожи на переменные, но после создания они не могут изменить свое значение.

```Swift
let x = 6 
let name = "Bob" 
let boole = true 
```


Чтобы вывести что-либо стандартным методом, просто используйте print() и поместите свой вывод в круглые скобки.


```Swift
let x = "World" 
 
print("Hello ") 
print(x) 
```

# Версия

17 сентября 2018 года была выпущенна последняя версия - [Swift 4.2](https://developer.apple.com/library/content/documentation/Swift/Conceptual/Swift_Programming_Language/RevisionHistory.html) . Язык постоянно развивается, поэтому в будущем нас ждет еще больше изменений. При запуске нового проекта рекомендуется использовать актуальную версию Swift.

# Документация


Swift хорошо документирован. Имейте в виду, что написание кода на Swift включает в себя не только использование языка, но и многие API. Лучше всего начать изучение Swift с создания скромного проекта или небольшого приложения.

*   [Исходный код](https://github.com/apple/swift)
    
*   [Разработка приложений iOS (Swift)](https://developer.apple.com/library/content/referencelibrary/GettingStarted/DevelopiOSAppsSwift/): 
Хотите создать приложение для iOS? Начните здесь!

    
*   [Справочник по языку](https://developer.apple.com/library/content/documentation/Swift/Conceptual/Swift_Programming_Language/): содержит обзор практически всех особенностей Swift. Он поможет вам, если вы запутались, читая чужой код.
    

# Хотите узнать больше?


*   [RayWenderlich.com](https://www.raywenderlich.com/) : Есть много отличных учебников для Swift и iOS.

*   [Взлом с Swift](https://www.hackingwithswift.com/read) : полный учебник Swift, который позволяет вам начинать до продвинутых, используя практические проекты.

### Источники

1.  «Swift 4 - мощный язык программирования, который также легко усваивается». Apple, [developer.apple.com/swift](https://developer.apple.com/swift/).

