---
title: Variables
localeTitle: Переменные
---
## Переменные

Переменная связывает имя со значением определенного типа. В Swift существуют два основных способа создания переменных. `let` и `var`. Чтобы объявить константы, используйте служебное слово `let`. Чтобы объявить изменяемые переменные, используйте служебное слово `var`.

Такой двоякий подход к хранению переменных в Swift позволяет избежать ошибок изменения переменных, которые должны быть константами.

```Swift

  let daysInAWeek = 7
  var amountOfMoney = 100


  amountOfMoney = 150
  // Значение amountOfMoney теперь 150


  daysInAWeek = 10
  // Эта строка вызовет ошибку!

 ```


В этом случае переменная `daysInAWeek` должна быть константой, потому что  в неделе только семь дней, а переменная `amountOfMoney` должна иметь возможность меняться, потому что сумма денег на счету изменяется.

Имена констант и переменных могут содержать почти любой символ, включая символы Unicode:

```Swift
  let π = 3.14159 
  let 你好 = "你好世界" 
  let 🐶🐮 = "dogcow" 
```

Чтобы проверить правильность значений переменных, используйте `print()` .

```Swift
  let money = 50 
 
  print(money) 

  // Эта строка выведет 50 


#### Дополнительная информация:


* [The Swift Programming Language](https://docs.swift.org/swift-book/LanguageGuide/TheBasics.html#ID310)

