---
title: TypeScript
localeTitle: Машинопись
---
## Машинопись

### обзор

![Машинопись](https://i.imgur.com/uRLunzU.png)

Так что, как вы, скорее всего, знаете, JavaScript расширяет свой след каждый день, и это одновременно и потрясающее, и потрясающее, что вы можете делать с языком в наши дни.

Однако, поскольку более масштабные проекты начинают использовать JavaScript, процесс упрощения написания кода и более удобного обслуживания становится все труднее.

Это проблема, которую Microsoft рано узнала, и они придумали решение TypeScript и выпустили первую версию примерно 1 октября 2012 года.

Вы можете узнать больше о различиях синтаксиса в [`TypeScript`](./) > [`JavaScript vs TypeScript`](./javascript-vs-typescript) .

![Ключевая особенность](https://i.imgur.com/pZij95O.jpg)

По сути, TypeScript пытается помочь JavaScript достичь новых высот и стать очень масштабируемым и может выделяться следующими функциями:

*   свободный и открытый язык программирования, разработанный и поддерживаемый Microsoft
*   строгий синтаксический супер-набор JavaScript, который компилируется в обычный JavaScript
*   упрощает разработку приложений большого масштаба, написанных на JavaScript
*   расширяет JavaScript, добавляя статические типы, классы, модули, интерфейсы и дженерики

**🎉 FUN FACT** TypeScript исполнилось 5 лет 1 октября 2017 года.

### Версия

Последней стабильной версией является [TypeScript 3.1](https://www.typescriptlang.org/docs/handbook/release-notes/typescript-3-1.html) .

### Монтаж

Подробнее об установке см. В разделе « [`TypeScript`](./) > « [`Installation`](./installation) .

### ЛИНТЕР

Чтобы узнать больше об использовании linter с TypeScript, проверьте [`TypeScript`](./) > [`Linter`](./linter) .

### Детская площадка

![Детская площадка](https://i.imgur.com/vlV7ZFr.png)

Если вы хотите попробовать TypeScript без его установки, посетите [Playground](http://www.typescriptlang.org/play/index.html) .

Игровая площадка имеет встроенное автоматическое завершение и возможность прямого просмотра испускаемого JavaScript.

### Другие источники

Подробнее об установке см. В [Приложении](./src/articles/typescript/appendix-installation/index.md) к [установке](./src/articles/typescript/appendix-installation/index.md) .

Если вам нужна только проверка типов и вы не хотите компилировать свою программу, прочитайте о [Flux](https://facebook.github.io/flux/) .

*   [Быстрый старт](http://www.typescriptlang.org/samples/index.html)
*   [Документация](http://www.typescriptlang.org/docs/home.html)
*   [Исходный код](https://github.com/Microsoft/TypeScript)
*   [TutorialsPoint](https://www.tutorialspoint.com/typescript/)