---
title: Alignment
localeTitle: центровка
---
## центровка

Типографическое выравнивание изменяет поток текста в документе. Дизайнеры могут использовать этот мощный инструмент, чтобы тонко улучшить представление текста, предоставив ему визуальную форму и контекст.

Экспериментируйте с выравниванием, чтобы найти интересные новые визуальные комбинации, которые делают ваш контент выделяющимся. Обязательно проверяйте ошибки выравнивания на разных устройствах и в браузерах.

Используйте CSS для выравнивания текста, когда это возможно. Вы можете столкнуться с тегами выравнивания HTML (например, `<p align="right"></p>` или `<center></center>` ), но они устарели в HTML 5.

### Левосторонний текст

По умолчанию, `text-align: left;`

Если у вас есть сомнения, предпочтительным вариантом выравнивания текста по умолчанию является лучший выбор. Особенно для статей или длинных блоков текста левый текст легче всего читать, так как оборванные края справа обеспечивают визуальный контекст, который помогает читателям сохранять свое место, когда их глаза смещаются от линии к линии.

Использовать для:

*   Основной текст
*   Больше всего остального

### Правый текст

`text-align: right;`

Правильно подобранный, левый текст может быть полезен как визуальная специя, но его труднее читать в длинных отрезках, чем текст с левым выравниванием.

Может использоваться для:

*   Титры
*   навигация
*   Sidebars
*   цитаты

### Центрированный текст

`text-align: center;`

Используйте центрированный текст, чтобы вытащить глаза читателей на точки внимания (например, заголовки, названия страниц, нижние колонтитулы). Не используйте центрированный текст для длинных блоков текста, так как чрезвычайно утомительно читать.

Может использоваться для:

*   Заголовки
*   Заголовок страницы
*   навигация
*   Sidebars
*   Титры
*   цитаты
*   колонтитулы

### Обоснованный текст

`text-align: justify;`

Полноценный текст сложно рекомендовать для основного текста, так как большие пробелы могут появляться между словами в некоторых строках. Тем не менее, опытные десригеры могут использовать его красиво.

Может использоваться для:

*   Титры
*   Sidenotes

#### Дополнительная информация:

*   [Статья Википедии](https://en.wikipedia.org/wiki/Typographic_alignment)
*   [Руководство по веб-стилю](https://webstyleguide.com/wsg2/type/align.html)
*   [Выравнивание текста в Интернете](http://www.webpagemistakes.ca/text-alignment-on-the-web/)