---
title: Anatomy of Letterforms
localeTitle: Анатомия букв
---
## Анатомия букв

В анатомии Letterforms описываются различные элементы, которые составляют печатные буквы в шрифте. На рисунке ниже показаны разные части букв шрифта.

![alt text](https://upload.wikimedia.org/wikipedia/commons/a/a3/Typographia.svg)

> Части глифа: 1) x-height; 2) линия подъема; 3) вершина; 4) базовый уровень; 5) восходящий; 6) перекладина; 7) стебель; 8) засечка; 9) нога; 10) чаша; 11) счетчик; 12) воротник; 13) петля; 14) ухо; 15) связь; 16) горизонтальная полоса; 17) рука; 18) вертикальная полоса; 19) высота крышки; 20) линия спуска.

Типовой шрифт в целом состоит из 3-х различных частей: 1) **штрихов** 2) **клемм** 3) **пространства**

#### Штрихи

Обводка относится к основному тексту формы письма. Они могут быть прямыми, как в буквах, таких как _l_ , _z_ , _k_ , _v_ или изогнутых, как в _c_ или _o_ . Различные части хода приведены ниже

*   Мнимая линия, на которой сидит большинство персонажей, известна как **базовая** линия (4).
    
*   Capheight или **capline** (19) - другая воображаемая линия, изображающая высоту всех прописных алфавитов.
    
*   Мнимой горизонтальной линией, которая отмечает верхний край строчных букв, является **средняя линия** .
    
*   Высота **x** (1) - это высота строчной буквы x. Другими словами, это расстояние между базовой линией и средней линией.
    
*   Основной вертикальный или диагональный штрих в форме письма известен как **Stem** (7).
    
*   Шаги, которые соединяют две строки в заглавных буквенных формах _A_ и _H_ или поперечные штрихи в _t_ , известны как **Crossbar** (6).
    
*   Когда ход строчной буквы поднимается над срединной линией, как в _l,_ он называется **восходящим** (5). Линия **Ascender** (2) представляет собой воображаемую линию, изображающую расстояние между базовой линией и верхней частью зажима.
    
*   Когда штрих букв в нижнем регистре падает ниже базовой линии, как в _g,_ он называется **descender** . Линия **Descender** (20) представляет собой воображаемую линию, изображающую расстояние между базовой линией и нижней частью спускового механизма.
    
*   Обводной ход, как и в верхней части _R_ , называется **Плечом** или иногда просто _аркой_ , как в _h_ , _n_ , _m_ .
    
*   Закрытый изогнутый ход называется **Чаша** (10).
    
*   Нижний диагональный ход, наблюдаемый в _K_ и _R_ , называется **Leg** (9).
    
*   Короткий горизонтальный ход, наблюдаемый в центре _e_ , _f_ и в середине хода _E_ и _F_ , называется **баром** .
    
*   Более длинный горизонтальный штрих сверху или снизу, как видно из _E_ и _F_ , называется **рукояткой** (17).
    
*   Точка над нижним регистром _j_ и _i_ называется **Tittle** или точкой или jot.
    
*   Нижняя часть двухэтажного _g_ называется **Loop** (13).
    

#### терминалы

Терминалы - это конец штрихов. Они представляют собой два типа **серифа** и **сан-серифа** . Сертифицированный терминал имеет пропуски по краям, которые можно охарактеризовать как клин, луковичный, слезоточивый, сляб и т. Д. С другой стороны, у Sans-Serif нет этих расширяющихся признаков в конце штрихов. Sans-Serif часто используется на цифровых дисплеях в наши дни, поскольку они имеют лучшую четкость на дисплеях с более низким разрешением, где трудно отобразить засечки.

#### Космос

Пространство относится к пробелу, который находится между буквами, а также внутри букв, таких как _o_ и _p,_ с замкнутыми контурами.

Ниже приведены некоторые базовые определения, которые помогут вам понять, как описывается и измеряется тип.

## гарнитура

Типовой шрифт относится к группе символов, таких как буквы, цифры и знаки препинания, которые имеют общий дизайн или стиль. Times New Roman, Arial, Helvetica и Courier - все шрифты.

## Шрифт

Шрифты относятся к средствам, с помощью которых отображаются или отображаются шрифты. Helvetica в подвижном типе - это шрифт, как и файл шрифта TrueType.

![Анатомия типографии](https://designschool.canva.com/wp-content/uploads/sites/2/2015/07/typography-terms-infographic-tb-1324x0.png)

## Семейство типов

Различные варианты, доступные в шрифте, составляют семейство типов. Многие шрифты доступны как по-римски, так и курсивом. Другие семьи намного больше, такие как Helvetica Neue, которые доступны в таких вариантах, как Condensed Bold, Condensed Black, UltraLight, UltraLight Italic, Light, Light Italic, Regular и т. Д.

## Шрифты Serif

Шрифты Serif распознаются маленькими линиями на концах различных штрихов персонажа. Поскольку эти строки облегчают чтение шрифта, направляя глаз от буквы к букве и слова к слову, шрифты с засечками часто используются для больших блоков текста, например, в книге. Times New Roman - пример обычного шрифта с засечками.

## Sans Serif Fonts

Серины - это маленькие линии на концах штрихов символов. Без засечек или без засечек относится к шрифтам без этих строк. Шрифты Sans serif часто используются, когда необходим большой шрифт, например, в заголовке журнала. Helvetica - популярный шрифт без засечек. Шрифты Sans serif также распространены для текста веб-сайта, так как их легче читать на экране. Arial - это шрифт без засечек, который был разработан специально для использования на экране.

## Размер точек

Эта точка используется для измерения размера шрифта. Одна точка равна 1/72 дюйма. Когда символ упоминается как 12pt, описывается полная высота текстового блока (например, блок подвижного типа), а не только сам символ. Из-за этого два шрифта с одинаковым размером точки могут отображаться как разные размеры, в зависимости от положения символа в блоке и от того, какая часть блока заполняется символом.

## цицеро

Пика обычно используется для измерения строк текста. Одна пика равна 12 пунктам, а шесть пиков равны одному дюйму.

## базисный

Базой является невидимая строка, на которой сидят персонажи. Хотя базовый уровень может отличаться от шрифта к шрифту, он согласован в шрифте. Закругленные буквы, такие как «е», будут немного ниже базовой.

## X-высота

Х-высота - это расстояние между средней линией и базовой линией. Он называется x-height, потому что это высота строчной буквы «x». Эта высота может сильно различаться между шрифтами.

## Отслеживание, Кернинг и Письмо

Расстояние между персонажами контролируется отслеживанием, кернированием и буквенным пространством. Отслеживание настраивается для изменения пространства между символами последовательно по блоку текста. Это можно использовать для повышения удобочитаемости для всей статьи журнала. Кернинг - это сокращение пространства между символами, а буквенное пространство - это добавление пространства между символами. Эти небольшие точные корректировки могут использоваться для настройки определенного слова, например, в дизайне логотипа, или большого заголовка истории в газете. Все настройки могут быть использованы для создания художественных текстовых эффектов.

## ведущий

Ведущее относится к расстоянию между строками текста. Это расстояние, измеренное в точках, измеряется от одной базовой линии до следующей. Блок текста может упоминаться как 12pt с 6pts дополнительного ведущего, также известного как 12/18. Это означает, что существует 12pt типа на 18pts общей высоты (12 плюс 6pts дополнительного руководства).

Исходный уровень: воображаемая горизонтальная линия, на которой лежит большинство букв.

Высота крышки: воображаемая горизонтальная линия, которая отмечает, что все заглавные буквы заканчиваются в самой высокой точке.

Перекладина: горизонтальная линия, соединяющая две другие линии в букве, такой как «A» или «H».

Счетчик: отрицательное пространство внутри буквы. Счетчик может быть полностью закрыт, как буквы «O» или «A», или частично закрыт как буквы «C» или «U».

Descender: воображаемая горизонтальная линия, которая отмечает самую низкую точку специальных букв нижнего уровня, таких как «g», «j», «p», «q» и «y».

Нога: нижний угловой ход в буквах, таких как «K», «R» и «Q».

Средняя линия: воображаемая горизонтальная линия, которая обозначает верхнюю точку строчных букв.

Serif: Окончательный штрих в конце текста, который создает «ногу».

Стебель: основной вертикальный ход в форме письма. Это также может быть диагонально, как в буквах «W» или «N».

Титл: точка над строчными буквами, такими как «i» и «j».

Letterform в целом относится к форме букв и включает в себя типографику. Типография - это вид печатных букв. Для понимания типографии требуется определенная лексика. Изучая условия типографии, вы также можете стать более критичным зрителем печатного типа.

#### Дополнительная информация:

*   [Википедия](https://en.wikipedia.org/wiki/Typeface_anatomy)
*   [Sitepoint](https://www.sitepoint.com/the-anatomy-of-a-letterform/)
*   [Typomil](http://typomil.com/anatomy/index.html)