---
title: Choosing a Typeface
localeTitle: Выбор шрифта
---
## Выбор шрифта

Форма следует за функцией: работайте с общими принципами, не выбирайте шрифты наугад.

### Когда вы не можете выбрать

При выборе другого шрифта не может быть и речи, вы можете часто добавлять визуальную специю в проект, настраивая размеры шрифта, веса и стили. Кроме того, всегда лучше попробовать стратегию хита и промаха, попробовав несколько разных шрифтов, прежде чем отказаться от выбора другого шрифта. Таким образом, может быть, вы не получите желаемого шрифта, но у вас будет представление о других других шрифтах, которые вы могли бы использовать в других случаях.

### Когда ты можешь

#### Соответствующее приложение

Вы не хотите выделяться плохо. Потребности вашего проекта часто ограничивают ваши творческие предпочтения: руководящие принципы брендинга компании, время загрузки и рендеринга, стандартные настройки операционной системы, доступность, поддержку браузера и т. Д.

Ищите реальные примеры проектов, подобных вашим, чтобы понять, какие шрифты или стили типичны. Дизайнеры оттачивали эти нормы через годы тестирования и тщательного рассмотрения.

#### Работать вместе

Тщательно выберите контрастные шрифты (например, Minion и Myriad) и веса (например, полужирный и обычный). Не используйте слишком много или слишком похожих шрифтов. Более трех шрифтов на одной странице должно дать вам паузу - часто либо содержимое слишком сложно для одной страницы, либо дизайн является неприменимым.

Изучите наиболее распространенные типы шрифтов (Geometric Sans, Humanist Sans, Oldstyle, Transitional и Modern, Slab Serifs) 1 и как они взаимодействуют, и вы сможете более хорошо манипулировать несколькими шрифтами вместе.

#### Нарушать правила

В конце концов, рекомендации могут занять вас до сих пор. Творчество и удивление являются важными компонентами проектных работ. Столько, сколько вы обращаете внимание на стандарты и конвенции, обратите внимание на выбросы. Изучите, как и почему они нарушают правила, чтобы сообщить свое собственное нарушение правил.

## Советы по быстрому выбору шрифта

*   Планирование вашей иерархии
*   Подумайте о том, что другие сделали уже
*   Экспериментируйте легкий путь
*   Избегайте анахронизмов
*   Избегайте правильных корреляций
*   Рассмотрим расширенное семейство типов
*   Придерживайтесь классических комбинаций
*   Использование ограниченной палитры

#### источники

1.  Дэн Мейер, [какой шрифт мне следует использовать? 5 Принципы выбора и использования шрифтов](https://www.smashingmagazine.com/2010/12/what-font-should-i-use-five-principles-for-choosing-and-using-typefaces/) , smashingmagazine.com, 2010.

#### Дополнительная информация:

[20 идеальных спариваний](http://www.creativebloq.com/typography/20-perfect-type-pairings-3132120) [Выбор правильного шрифта - краткая статья для справки](https://webdesign.tutsplus.com/articles/choosing-the-right-font-a-practical-guide-to-typography-on-the-web--webdesign-15?_ga=2.210603089.55465761.1538586153-769794395.1538586153)

#### Дополнительная информация:

*   [Smashing Magazine статья - Как выбрать шрифт](https://www.smashingmagazine.com/2011/03/how-to-choose-a-typeface/)