---
title: Legibility and Readability
localeTitle: Легкость и удобочитаемость
---
## Легкость и удобочитаемость

### разборчивость

**Разборчивость** означает возможность различать разные символы в тексте. Разумный текст подразумевает, что его можно легко интерпретировать. Посмотрите на уникальные характеристики шрифта при рассмотрении удобочитаемости. Вот некоторые из следующих соображений:

*   Вы должны использовать каждый шрифт в соответствии с его _контекстом и предполагаемым использованием_ . Посмотрите на его историю, и это лучшие сценарии использования. Например: Garamond лучше всего использовать для больших текстовых текстов, а для экрана - для Грузии.
*   Имейте в виду, является ли шрифт _текстовым или текстовым текстом_ .
*   X-высота шрифта - это размер нижнего регистра «x» в шрифте. Типовой шрифт со _средней и высокой высотой x_ приводит к получению текста с четкими размерами.
*   Обычно шрифты **с** засечками более разборчивы для основного текста, чем их аналог без засечек.

### читабельность

**Чтение** означает организацию группы слов или блоков текста таким образом, чтобы сделать текст более доступным. Идея состоит в том, чтобы уменьшить объем усилий, необходимых для чтения текста.

Стивен Коулз замечает, что читаемость не только ставит вопрос: «Можете ли вы это прочитать?» но **«хотите** ли **вы его прочитать?»** ,

Джейсон Санта-Мария указывает в своей книге « _О веб-типографии»,_ что чтение не является линейной деятельностью. Мы читаем взад и вперед движение, называемое **саккадами** , которое наши глаза прыгают от одной точки к другой. Кроме того, текст со знакомыми словами облегчает нам чтение. Некоторые основные моменты, которые следует учитывать при рассмотрении читаемости, следующие:

*   **Контрастность** относится к изменению толщины штриха в разных частях буквы. Чем выше контраст, тем выше изменение хода. Используйте шрифты среднего и низкого контраста для длинных текстов.
    
*   **Высота линии** относится к расстоянию между двумя строками текста. Вы не хотите, чтобы блок текста не был слишком плотным или слишком свободным. Вы можете контролировать высоту строки в CSS с помощью свойства 'line-height'. Для большинства текстов вы можете установить его в диапазоне от 1,2 до 1,5 (без каких-либо единиц).
    
*   **Длина линии** (мера) относится к среднему числу символов в строке текста. Большая длина строки затрудняет читаемость, затрудняя просмотр глаз для текста. Обычно около 45-75 символов на строку оптимальны для текста. Если вы планируете увеличить длину линии за ее пределами, тогда также обратите внимание на увеличение высоты строки, чтобы было достаточно места между двумя строками текста. В CSS вы можете установить ширину контейнера, и с помощью модуля em вы можете приблизиться к заданному числу символов в зависимости от соотношения ширины и высоты шрифта. Пример: ширина: 35 мкм;
    
*   **Отслеживание** - это настройка пробела между символами в тексте. Добавление отслеживания означает добавление пробела между символами и наоборот. При небольших размерах шрифтов, т.е. менее 10pts, добавление отслеживания помогает улучшить читаемость. Аналогично, для больших заголовков используйте негативное отслеживание, чтобы приблизить буквы. Вы можете контролировать отслеживание в CSS с помощью свойства «letter-spacing». Например: буквенный интервал: 0.05em;
    
*   **Размер шрифта** относится к размеру шрифта, используемого в тексте. Для мобильного дисплея используйте размеры не менее 12 пикселей. Вы можете управлять размером шрифта в CSS с помощью свойства font-size. Пример: font-size: 48px;
    

Как вы можете видеть, вам необходимо учитывать множество факторов, чтобы обеспечить оптимальную удобочитаемость и удобочитаемость. Помните, что нет никаких жестких и быстрых правил для любого из вышеперечисленных факторов. Это простые рекомендации, которые могут помочь вам лучше подготовить ваш типографский глаз.

### Дополнительные ссылки:

*   [Практико-типография](https://practicaltypography.com) для основ типографии.
*   [Веб-дизайн Tutsplus](https://webdesign.tutsplus.com/articles/typographic-readability-and-legibility--webdesign-12211) - статья о удобочитаемости и удобочитаемости
*   [В веб-типографии](https://abookapart.com/products/on-web-typography) - книга о типографии в Интернете.