---
title: Point Size
localeTitle: Размер точки
---
## Размер точки

Размер точки - это способ стандартизации типографики. Размер точки - наименьшая единица измерения.

В металлическом типе размер точки относится к высоте металлического тела, на котором нанесен характер шрифта. В цифровых шрифтах металлический корпус заменяется невидимой коробкой, известной как _квадрат em_ . Каждый символ помещается внутри этого квадрата em или em. Размер **em шрифта равен его размеру точки.**

```css
html{ 
  font-size:16px; 
 } 
 
 body{ 
  font-size:1em;  // 1em is equal to 16px 
 } 
```

Размер точки также используется для измерения высоты (линии), длины линии и других элементов, кроме размера шрифта.  
В цифровых шрифтах **одна точка равна 1/72 дюйма** . Двенадцать очков составляют одну пику. Шесть пиков составляют один дюйм. Обычный способ представления picas и points выглядит следующим образом:

*   1 pica = 1p
*   1 балл = 1 оч. Или p1
*   6 пиков и 3 балла = 6p3
*   7-точечные Open Sans с 9 очками: 7/9 Open Sans

Оптимальный размер точки для печати обычно составляет от 10 до 12 баллов, а для сети - оптимальный размер точки - 15-25 точек. В CSS вы должны установить размер шрифта в ems или rems, чем пиксели, поскольку первые являются масштабируемыми по своей природе. В последнее время много говорят о типографии с использованием недавно введенных единиц vw и vh. Узнайте больше об этом здесь: [Жидкостная типография](https://www.smashingmagazine.com/2016/05/fluid-typography/)

Помните, что разные шрифты, установленные в одном и том же размере, не будут иметь одинаковый размер из-за их индивидуальных характеристик, а именно: x-height, модуляция хода или контрастность и ширина символов.

#### Дополнительная информация:

*   [Размер точки](https://practicaltypography.com/point-size.html) Практическая типография
*   [Размер точки](https://en.wikipedia.org/wiki/Point_(typography)) Википедия
*   [Мышление с типом](http://amzn.to/2yDqGNR) мышления с типом