---
title: Type Classifications
localeTitle: Классификация типов
---
## Классификация типов

Почти все шрифты попадают в одну группу. Эта система классификации шрифтов развивалась в девятнадцатом веке. У каждого шрифта есть своя визуальная структура, влияние, намерение и историческое значение.

Основная классификация шрифтов такова:

*   **Serifs** : Эти шрифты имеют небольшие расширения, которые украшают основную структуру шрифта. Серийные шрифты существовали с начала типа. Они видны в стиле Старого и Гуманистического типа, таких как Гарамонд. Баскервиль, другой шрифт с засечками, относится к переходной эпохе. Bodoni и Rockwell являются частью шрифтов Modern и Slab с засечками (египетскими).
    
*   **Без засечек** : Без сан. Эти шрифты лишены этих небольших расширений, следовательно, без засечек. Примеры включают Gill sans, у которого есть гуманистические коннотации, Helvetica с его переходными характеристиками и так далее.
    
*   **Сценарий** : Письменные формы, разработанные в тесной связи с человеческим почерком, являются шрифтами шрифтов. Они имеют гибкую природу с изменяющейся шириной хода. Пример: сценарий бистро, шелли, минстраль и т. Д.
    
*   **Blackletter** : Смелый стиль каллиграфии, используемый в течение всего периода ренессанса. Пример: Fraktur
    
*   **Декоративные** : шрифты, которые не подходят в других категориях, являются декоративными по своему характеру. Построен для конкретных случаев использования, которые в основном состоят из заголовков, плакатов и т. Д.
    
    Кроме того, три основные группы для классификации типа, соответствующие различным периодам времени в искусстве и литературе, следующие:
    
*   **Гуманистические** формы письма относятся к периоду ренессанса около 15 и 16 веков. Они тесно имитируют каллиграфию и движение человеческой руки. Старые засечки следовали гуманистическим письмам. Примеры гуманистического типа: Сабон, Кентавр, Адоб Дженсон, Гилл Санс и др.
    
*   Формы **переходных** букв являются частью эпохи барокко. Они представляют собой переход от гуманистических шрифтов старого стиля к современным шрифтам. Примеры: Baskerville, Times Roman, Helvetica и т. Д.
    
*   **Современные** формы письма являются частью периода просвещения около 18-19 вв. Они изображают радикальный переход от традиционной типографии к более абстрактному дизайну. Примеры: Bodoni, Futura и т. Д.
    

![Изображение типовой классификации](http://thinkingwithtype.com/images/Thinking_with_Type_Letter_12.gif)

> Изображение взято из онлайн-версии книги «Мышление с типом» Эллен Луптон

#### Дополнительная информация:

*   История [классификации типов](http://www.designishistory.com/1450/type-classification/)
*   [Классификация Vox-Atypl](https://en.wikipedia.org/wiki/Vox-ATypI_classification) Wikipedia
*   [Мышление с типом](http://thinkingwithtype.com/letter/#type-classification)
*   [Классификация типов - 6 часть серии](http://ilovetypography.com/2007/11/06/type-terminology-humanist-2/) Я люблю Типографию