---
title: Human Computer Interaction
localeTitle: Взаимодействие человека с компьютером
---
## Взаимодействие человека с компьютером

Человеко-компьютерное взаимодействие (HCI) - это область исследований, которая фокусируется на разработке компьютерных технологий и, в частности, взаимодействии между людьми (пользователей) и компьютеров. Он охватывает множество дисциплин, таких как информатика, когнитивная наука и инженерия человеческих факторов. Хотя это изначально связанные с компьютерами, HCI с тех пор расширилась, чтобы охватить практически все формы проектирования информационных технологий.

Люди взаимодействуют с компьютерами в основном через графические пользовательские интерфейсы (GUI), а иногда и через голосовые пользовательские интерфейсы (VUI). В поле пользователя Опыт / взаимодействие с пользователем (UX / UI), взаимодействие с человеческим компьютером изучается для обеспечения оптимальной удовлетворенности пользователей и взаимодействия с частью программного обеспечения.

### Принципы дизайна

Для проектирования или оценки пользовательского взаимодействия можно применить несколько принципов экспериментального проектирования:

*   Раннее внимание к пользователю и задаче: укажите, сколько пользователей необходимо для выполнения задачи (задач) и определить, кем должны быть соответствующие пользователи; кто никогда не использовал интерфейс и не будет использовать интерфейс в будущем, скорее всего, не является допустимым пользователем. Кроме того, определите задачи (задачи), которые будут выполняться пользователями, и как часто выполняются задачи.
*   Эмпирическое измерение: сначала проверьте интерфейс на реальных пользователях, которые ежедневно вступают в контакт с интерфейсом. Имейте в виду, что результаты могут отличаться от уровня производительности пользователя и не могут быть точным описанием типичного взаимодействия человека и компьютера. Установите количественные особенности юзабилити, такие как: количество пользователей, выполняющих задачи (задачи), время выполнения задачи (задач) и количество ошибок, возникающих во время задачи (задач).
*   Итеративный дизайн: после определения пользователей, задач и эмпирических измерений для включения выполните следующие итерационные этапы проектирования:

1.  Проектирование пользовательского интерфейса
2.  Контрольная работа
3.  анализировать
4.  Повторение

### Отношение к дизайну пользовательского опыта (UX)

Во многих отношениях HCI была предшественником, который стал бы тем, что мы теперь называем «дизайном пользовательского опыта (UX)». Несмотря на это, некоторые различия сохраняются между дизайном HCI и UX. Практикующие HCI, как правило, более академически ориентированы и участвуют в научных исследованиях и разработке эмпирических понятий пользователей. С другой стороны, дизайнеры UX, как правило, ориентированы на отрасль, и большинство разработчиков UX участвуют в создании продукта или услуги - например, приложения для смартфонов или веб-сайта. Независимо от этой разницы, практические соображения для продуктов, к которым относятся дизайнеры UX, имеют прямую связь с выводами специалистов HCI о менталитетах пользователей. В связи с этим мало что нужно для разделения этих сфер.

#### Дополнительная информация:

*   [Взаимодействие с человеческим компьютером (Википедия)](https://en.wikipedia.org/wiki/Human–computer_interaction)
*   [Энциклопедия человеко-компьютерного взаимодействия, 2-е изд.](https://www.interaction-design.org/literature/book/the-encyclopedia-of-human-computer-interaction-2nd-ed/human-computer-interaction-brief-intro)