---
title: Information Architecture
localeTitle: Информационная архитектура
---
## Информационная архитектура

Информационная архитектура, или IA, обычно предпринимается профессионалом пользовательского опыта (UX) с опытом работы в дисциплине UX. (IA является частью UX). Это не креативное / визуальное проектирование, а основное внимание уделяется проектированию информации, потокам пользовательских задач и сценариям, вариантам использования, контенту, информационной иерархии.

Типы документов, которые производятся в практике IA, обычно называются файлами Sitemap (отличными от блок-схем), картами функций, картами контента и инвентарями (хотя они также могут быть созданы редакторами контента). IA также заботится о фактической словоблудии, используемой во всей навигации и содержании сайта или продукта, с целью обеспечения ясности и последовательности. Вы увидите ссылку на «поездки клиентов», но это не UX или IA - это совсем другое.

Это помогает узнать, где находится IA в рамках схемы команды и другой документации. Высокоуровневый поток проектной документации и процесса выглядит следующим образом: (обратите внимание: предполагается, что клиент подписывается в нескольких точках процесса)

1.  Фаза обнаружения и запуск: краткое описание проекта, сбор требований (технический, функциональный, креативный / бренд, контент).
2.  Фаза UX-IA: исследование> персонализация> потоки пользователей> файлы Sitemap> каркасы. Детали проектирования взаимодействия обрабатываются и завершаются. Если прототипы ограничены (в бюджете), образцы образцов создаются с учетом потоков пользователей и дизайна взаимодействия, а также объявление, если оно готово к расписанию.
3.  Творческий Deisgn: грубые макеты (сообщается всей документацией до этого момента), высокоточные макеты (с более точным финальным изображением и контентом), готовые и готовые к производству предметы искусства, выпущенные и выпущенные dev.
4.  Дев работал за кулисами, как правило, гибкий или гибкий подход к методологии. Dev, UX и творческие сотрудничают по различным аспектам проекта в любой момент времени. Они все знают, что нужно каждому, и ожидает от другого.  
    (Это общий обзор того, как будет работать мультидисциплинарная команда. В процессе разработки много переменных, которые влияют на процесс. В конечном итоге лучший процесс - это то, что команда и клиент могут сформулировать и придерживаться, и это дает желаемый конечный результат. )

IA является важной дисциплиной в процессе создания цифрового продукта / опыта. Когда все будет хорошо, оно будет прозрачным и незаметным. Когда это делается плохо, оно растворяет доверие клиентов в команде, приводит к дополнительной работе / времени / затратам денег, возможному задержкам в результатах и ​​если их не поймать до отправки / запуска, это может смутить клиента целевой аудитории - не полезно для производства команда.

## Другие источники

*   [Информационная архитектура - Википедия](https://en.wikipedia.org/wiki/Information_architecture)
*   [Usabilty.gov](https://www.usability.gov/what-and-why/information-architecture.html)