---
title: Pattern Libraries
localeTitle: Библиотеки шаблонов
---
## Библиотеки шаблонов

Библиотека шаблонов представляет собой набор элементов дизайна многоразового пользовательского интерфейса. Поскольку эти элементы ui многократно используются многократно на веб-сайте, веб-приложении или программном приложении, они навязывают структуру посредством согласованности. Это упрощает использование сайта или приложения.

Несколько общих элементов ui, найденных в библиотеке шаблонов:

*   меню
*   Кнопки
*   Макеты страниц
*   Пользовательские анимации
*   формы

### Преимущества шаблонных библиотек

Пол Боаг из своего блога [Boagworld.com](https://boagworld.com/design/pattern-library/) объясняет основные причины создания библиотеки шаблонов:

1.  «Библиотека шаблонов обеспечивает согласованный пользовательский интерфейс».
2.  «Библиотека шаблонов облегчает повторное использование».
3.  «Библиотека шаблонов упрощает обслуживание».

### Библиотеки шаблонов против систем проектирования и стилей

Легко путать библиотеки шаблонов с системами проектирования и руководствами по стилям. В этой [статье Зак Резерфорд для UXPin](https://www.uxpin.com/studio/blog/design-systems-vs-pattern-libraries-vs-style-guides-whats-difference/) разъясняется разница между тремя:

> • **Система проектирования** - полный набор стандартов проектирования, документации и принципов вместе с инструментарием (шаблоны пользовательского интерфейса и компоненты кода) для достижения этих стандартов.
> 
> • **Библиотека шаблонов** - подкласс в системе проектирования, это набор шаблонов проектирования для использования в компании.
> 
> • **Руководство по стилю.** Еще один подкласс в системе проектирования, эта статическая документация описывает саму систему проектирования: как продукты должны выглядеть и выглядеть, использовать случаи для шаблонов пользовательского интерфейса, правильные типографские шкалы и т. Д.

#### Дополнительная информация:

##### Примеры библиотеки образцов

[Mailchimp](https://ux.mailchimp.com/patterns)

[IBM Design Language](https://www.ibm.com/design/language/resources)

[Microsoft](https://developer.microsoft.com/en-us/windows/desktop/design)

[Материальный дизайн Google](https://material.io/guidelines/)

[Шаблоны пользовательского интерфейса](http://ui-patterns.com/patterns)

[Мобильные шаблоны](http://www.mobile-patterns.com/)

[BBC GEL](http://www.bbc.co.uk/gel/guidelines/category/design-patterns)

##### статьи

[«Библиотеки шаблонов» Наташи Хоккей для Prototypr.io](https://blog.prototypr.io/pattern-libraries-5d627c5c65b4)

[«Библиотеки шаблонов: что они и зачем вам нужно» от Meghan Lazier для Designlab](http://trydesignlab.com/blog/pattern-libraries-what-they-are-and-why-you-need-o/)

[«Создание библиотеки шаблонов» Ребекки Соренсен для сумо-логики](https://medium.com/sumo-logic-ux/creating-a-pattern-library-18cce0f901b4)

[«Начало работы с библиотеками шаблонов» Анны Дебенхам для A List Apart](http://alistapart.com/blog/post/getting-started-with-pattern-libraries)

[«Взятие библиотеки шаблонов на следующий уровень» Виталия Фридмана для журнала Smashing](https://www.smashingmagazine.com/taking-pattern-libraries-next-level/)