---
title: Personas
localeTitle: люди
---
## Personas

Персонажи используются в процессе проектирования в качестве руководства для создания пользовательского опыта на основе типов пользователей, которые будут иметь приложения. Persona представляет демографию людей, которые будут использовать приложение. Как правило, несколько персонажей создаются до разработки приложения. Персонажи помогут дизайнерам создавать различные проекты для разных типов пользователей.

Например, если в команде было создано приложение, которое обрабатывало членство и операции для фитнес-клуба, то некоторые из пользователей приложения могли бы включать в себя сотрудников наставников, продавцов и личных тренеров. Возраст, мышление и технические возможности этих пользователей могут быть разными. Таким образом, команда создала персону для каждого из этих типов пользователей и включала бы информацию о задаче, уровне навыка, целях, фону и кратком описании о повседневной деятельности этого человека.

## Пользовательское лицо

Пользователь persona является вымышленным профилем или представлением идеального пользователя, которого вы пытаетесь достичь. Дизайнеры используют персонажей для лучшего понимания своих пользователей и настройки дизайна для целевой аудитории.

Пользовательские лица показывают, как человек может использовать веб-сайт или приложение. Потребности пользователя, цели и поведение помогают разработчикам понять, как они используют продукт и что может сделать дизайн, чтобы пользователь мог выполнить определенное действие. Сильная пользовательская персона четко определяет, каковы эти потребности и важная информация, которая может повлиять на дизайн.

Дизайнеры UX находят как можно больше исследований, чтобы точно представлять своих пользователей. Информация организована в группы, которые представляют идеальных пользователей, которых вы хотите достичь. Дизайнеры часто сосредотачиваются на наиболее важных группах пользователей, потому что их легче проектировать для избранных, чем пытаться удовлетворить потребности всех.

Индивидуальные персонализированные лица - это одна страница и не содержат дополнительных сведений, которые не влияют на конечного дизайнера или помогают в принятии каких-либо конструктивных решений. Вы должны убедиться, что персонажи являются реалистичными и конкретными, насколько это возможно, поскольку это поможет вам найти реальных пользователей, когда вы будете готовы протестировать ваш продукт.

## Как определить свою персону пользователя

Дизайнеры имеют разные способы создания персоны пользователя, но четко определенные персоны имеют 4 элемента. Этими элементами являются:

1.Header 2.Демографический профиль 3.End Цель (ы) 4.Scenario

### Заголовки

Заголовки включают имя вашего пользователя, мага и часто цитату. Цитата - это то, как дизайнеры обобщают то, что, по мнению пользователя, важно. Сильный заголовок позволяет разработчикам сосредоточиться на тех пользователей, для которых они созданы.

### Демографические профили

Демографические профили содержат все данные исследований пользователей. Все данные дают разработчикам полную картину своих пользователей. В профиле есть четыре раздела: личный фон, профессиональный фон, пользовательская среда и психография.

Личный фон - это информация, такая как возраст, пол, этническая принадлежность и образование. Дизайнеры могут включать семейное положение (например, одинокие, замужние, овдовевшие и т. Д.) Или персональную группу (например, работающих мам). Профессиональный фон - это занятие, уровень дохода и опыт работы пользователя.

Пользовательская среда - это физический, социальный и технологический контекст пользователя. Эта информация показывает, что типичный день пользователя, где они проводят время и что делают с другими. Психографические исследования - это исследование того, как ваши пользователи думают и чувствуют. Эти данные ориентированы на отношение, интересы, мотивацию и болевые точки ваших пользователей.

### Конечная цель (цели)

Конечной целью является действие, которое пользователи предпринимают для достижения цели. Конечные цели мотивируют всех пользователей и показывают, что пользователям нужно или нужно.

### сценарий

Сценарии - это описание того, как пользователи будут использовать продукт для достижения конечной цели. Эти ситуации определяют, когда, где и как будет происходить это событие. Вы пишете эти сценарии с точки зрения пользователя.

#### Дополнительная информация:

*   [Персонажи - usability.gov](https://www.usability.gov/how-to-and-tools/methods/personas.html)
*   [Smashing Magazine: более внимательный взгляд на персонажи](https://www.smashingmagazine.com/2014/08/a-closer-look-at-personas-part-1/)