---
title: Qualitative Surveys
localeTitle: Качественные обследования
---
## Качественные обследования

Качественные обзоры, которые могут принимать форму интервью или других непосредственно наблюдаемых тестов юзабилити (могут быть лично или с помощью средств видеоконференций, таких как Skype или Google Hangouts) - должны быть поисковыми и с целью получения большего объема информации, глубокое понимание опыта пользователя. Качественные исследования направлены на сбор информации о повседневном жизненном опыте пользователя или группы и мотивации, чтобы увидеть, как эти данные могут повлиять на их использование продукта или инструмента.

### Результаты

При использовании методов качественных исследований важно, чтобы исследователь признавал, что они могут влиять на результаты исследований. Так как именно человеческий опыт исследуется вместо жестких данных (количество кликов, тенденции входа в систему и т. Д.), Трудно оставаться полностью объективным во время тестирования или при оценке результатов. Результаты также не обязательно будут воспроизводимыми. Это связано с тем, что факторы, которые влияют на опыт пользователя, различны и могут меняться изо дня в день. Эти факторы могут принимать форму более напряженного пользователя в один прекрасный день, чем другой, из-за новых событий в их жизни или с большим количеством обязанностей в тот день, у пользователей, имеющих совершенно другой жизненный опыт, чем у другой, плохая погода, влияющая на настроение пользователя и все остальное что влияет на личную или эмоциональную жизнь человека.

Результаты качественных опросов обычно отображаются как темы или категории, а не числа. 1

### пример

Вот отличный пример из « [The Interaction Design Foundation»](https://www.interaction-design.org/) о разнице между количественными исследованиями и качественными исследованиями:

> Чтобы проиллюстрировать разницу, скажем, вы хотите изучить привычки упражнений группы пользователей. Вы можете изучить их с помощью количественных или качественных методов исследования. **Если вы используете _количественный_ метод** , вы можете создать онлайн-опрос и распространить его на большое количество участников. Участники должны ответить на предопределенные вопросы об их привычках упражнений, таких как «Сколько часов в неделю вы тренируетесь?». Если вы выполняете свою работу послушно, ответы на опросы можно количественно суммировать без предвзятости из вашего собственного мнения или личного опыта с упражнениями.
> 
> **Если вы используете _качественный_ метод** , вы можете делать интервью с ограниченным количеством участников, где вы говорите участникам о том, когда, где и как они тренируются. Поскольку собеседование аналогично разговору, ваши результаты будут зависеть от того, как вы зададите последующие вопросы ответам участников, и как вы это сделаете, в какой-то степени зависит от вашей индивидуальности и вашего собственного опыта с упражнениями. Точно так же результаты интервью также в некоторой степени зависят от субъективной интерпретации того, что сказал вам участник.

### источники

1.  [Мортенсен, Дитте. «\[Лучшие практики для качественных исследований пользователей\] (https://www.interaction-design.org/literature/article/best-practices-for-qualitative-user-research)." _\[Фонд дизайна взаимодействия\] (https://www.interaction-design.org/)_ . Январь 2018. Доступ: 23 февраля 2018 г.](#)

### Ресурсы:

*   « [Качественные методы исследования в дизайне UX](https://www.slideshare.net/uxtalktokyo/ux-tokyo-talk-6-markus) » Маркуса Хеберлейна (презентация SlideShare, показанная на UX Tokyo Talk 2014)
    
*   « [12 методик исследования UX (количественный и качественный)](https://medium.com/ux-design-web-mobile-virtual-reality/12-ux-research-techniques-quantitative-and-qualitative-1a37bcb1914e) » Кевина Далви
    
*   « [Полное руководство для начинающих по исследованию UX](http://www.uxbooth.com/articles/complete-beginners-guide-to-design-research/) » [UX Booth](http://www.uxbooth.com/)
    
*   « [Краш-курс в UX Design Research](https://uxdesign.cc/a-crash-course-in-ux-design-research-ea00c3307c82) » Мэтта Лавуа в [UX Collective](https://uxdesign.cc/)