---
title: User-Centered Design
localeTitle: Пользовательский дизайн
---
## Пользовательский дизайн

Дизайн, ориентированный на пользователя (UCD) - это совокупность процессов, которые направлены на то, чтобы пользователи находились в центре дизайна и разработки продукта. UCD - это итеративный подход к разработке, который направлен на то, чтобы развить понимание потребностей пользователей, делая это посредством сочетания расследования (например, обследований и интервью) и генеративные (например, «мозговой штурм») методы и инструменты. Решающим моментом является то, что UCD в значительной степени включает пользователей на всех этапах проектирования и оценки. Дизайнеры изучают удобство использования, характеристики, среду и задачи продукта и внимательно следят за всеми этапами процесса проектирования.

Основная цель UCD - оптимизировать продукт, услугу или процесс вокруг того, как пользователи будут использовать продукт, а не принуждать пользователей к подтверждению или изменить свое поведение, чтобы адаптировать продукт.

### Фазы процесса UCD

1.  Укажите контекст использования: Определите людей, которые будут использовать продукт, для чего они будут использовать его, и при каких условиях они будут использовать его.
2.  Укажите требования: Определите любые бизнес-требования или цели пользователя, которые должны быть выполнены для успешного продукта.
3.  Создание дизайнерских решений: эта часть процесса может выполняться поэтапно, исходя из приблизительной концепции и полного дизайна.
4.  Оцените дизайн: оценка, в идеале - с помощью тестирования юзабилити с фактическими пользователями, является такой же неотъемлемой, как и проверка качества, - это хорошая разработка программного обеспечения

### Дизайн, ориентированный на пользователя, и дизайн, ориентированный на человека

Дизайн, ориентированный на пользователя, часто используется взаимозаменяемо с ориентированным на человека дизайном, но первый - это подмножество последнего. Дизайн, ориентированный на пользователя, относится не только к обслуживанию любого конкретного человека, но и к конкретному типу пользователя. Таким образом, ориентированный на пользователя дизайн требует более глубокого анализа пользователей - вашей целевой аудитории. Речь идет не только об общих характеристиках человека; речь идет о конкретных привычках и предпочтениях целевых пользователей при разработке правильных решений для конкретных проблем.

Дизайн, ориентированный на пользователя, учитывает возраст, пол, социальный статус, образование и профессиональный опыт, влиятельные факторы, ожидания и требования к использованию продукта и многие другие важные вещи, которые могут различаться для разных сегментов. Ориентированный на пользователя дизайн - это глубокие исследования, привычки, от их взаимодействия с продуктом до их видения того, как продукт должен выглядеть и вести себя.

#### Дополнительная информация:

*   [Дизайн, ориентированный на пользователя: введение](https://usabilitygeek.com/user-centered-design-introduction/) - полезность Geek
*   [Преимущества пользовательского проектирования](https://www.usability.gov/what-and-why/benefits-of-ucd.html)