---
title: User Research
localeTitle: Исследования пользователей
---
## Исследования пользователей

Методы исследований, основанные на опыте пользователя, отлично подходят для создания данных и понимания, в то время как текущие действия помогают получить правильные вещи. Наряду с НИОКР, текущие действия UX могут сделать все усилия более эффективными и ценными. На каждом этапе процесса проектирования различные методы UX могут поддерживать усилия по разработке продукта на правильном пути в соответствии с истинными потребностями пользователя, а не мнимыми.

#### 20 кратких примеров UX

Ниже приведено краткое описание методов исследования пользователей, показанных на приведенной выше диаграмме:

_Занятия в области юзабилити-лаборатории:_ участники вводятся в лабораторию один на один с исследователем и задают набор сценариев, которые приводят к задачам и использованию конкретных интересов в продукте или услуге.

_Этнографические полевые исследования:_ исследователи встречаются и изучают участников в их естественной среде, где они, скорее всего, столкнутся с рассматриваемым продуктом или услугой.

_Совместная разработка:_ участникам даются элементы дизайна или творческие материалы, чтобы построить их идеальный опыт конкретным способом, который выражает то, что для них важно больше всего и почему. Фокус-группы: группы из 3-12 участников проходят дискуссию по набору тем, давая вербальные и письменные отзывы через обсуждение и упражнения.

_Интервью:_ один из исследователей встречается с участниками один на один, чтобы подробно обсудить, что участник думает о данной теме.

_Eyetracking:_ устройство для наблюдения за глазами настроено так, чтобы точно определять, где участники смотрят, как они выполняют задачи, или естественно взаимодействуют с веб-сайтами, приложениями, физическими продуктами или средами.

_Юзабилити Бенчмаркинг:_ тщательно изученные юзабилити исследования проводятся с несколькими участниками, используя точные и предопределенные показатели производительности.

_Модерируемые дистанционные исследования_ юзабилити _:_ исследования удобства использования, проведенные дистанционно с использованием таких инструментов, как программное обеспечение для совместного использования экрана и возможности дистанционного управления.

_Unmoderated Remote Panel Studies:_ группа обученных участников, у которых есть программное обеспечение для записи видео и сбора данных, установленное на их собственных персональных устройствах, использует веб-сайт или продукт, думая вслух, имея опыт, записанный для немедленного воспроизведения и анализа исследователем или компанией.

_Концептуальное тестирование:_ исследователь разделяет аппроксимацию продукта или услуги, которая отражает ключевую сущность (ценностное предложение) новой концепции или продукта, чтобы определить, удовлетворяет ли она потребностям целевой аудитории; это может быть сделано один на один или с большим количеством участников и лично или онлайн.

_Исследования дневника / камеры:_ участникам дается механизм (дневник или камера) для записи и описания аспектов их жизни, имеющих отношение к продукту или услуге, или просто ядро ​​для целевой аудитории; дневные исследования обычно являются продольными и могут быть сделаны только для данных, которые легко записываются участниками.

_Обратная связь с клиентом:_ открытая и / или закрытая информация, предоставленная самостоятельно выбранной выборкой пользователей, часто через ссылку обратной связи, кнопку, форму или электронную почту.

_Исследования желательности:_ участникам предлагаются различные альтернативы визуального дизайна, и ожидается, что они _свяжут_ каждую альтернативу с набором атрибутов, выбранных из закрытого списка; эти исследования могут быть как качественными, так и количественными.

_Сортировка карт:_ количественный или качественный метод, который просит пользователей организовать элементы в группы и назначать категории для каждой группы. Этот метод помогает создавать или уточнять информационную архитектуру сайта, подвергая ментальные модели пользователей.

_Анализ Clickstream:_ анализ записи экранов или страниц, на которые пользователи нажимают и видит, поскольку они используют сайт или программный продукт; он требует, чтобы сайт был правильно настроен или приложение использовало возможность сбора телеметрических данных.

_Тестирование A / B (также известное как «многовариантное тестирование», «тестирование в реальном времени» или «тестирование ковша»):_ метод научного тестирования различных конструкций на сайте путем случайного присвоения групп пользователей взаимодействию с каждым из разных проектов и измерение влияния этих присвоений на поведение пользователя.

_Unmoderated UX Studies:_ количественный или качественный и автоматизированный метод, который использует специализированный исследовательский инструмент для захвата поведения участников (с помощью программного обеспечения, установленного на компьютерах-участниках / браузерах) и отношений (посредством встроенных вопросов опроса), обычно путем предоставления участникам целей или сценариев для выполнения сайт или прототип.

_True-Intent Studies:_ метод, который задает случайным посетителям сайта, какова их цель или намерение при входе на сайт, измеряет их последующее поведение и спрашивает, были ли они успешны в достижении своей цели после выхода на сайт.

_Intercept Surveys:_ опрос, который запускается во время использования сайта или приложения.

_Email Surveys:_ опрос, в котором участники набираются из сообщения электронной почты.

#### Дополнительная информация:

[UT Research Cheat Sheet](https://www.nngroup.com/articles/ux-research-cheat-sheet/)