---
title: Qualitative Testing
localeTitle: Качественное тестирование
---
## Качественное тестирование

Качественное тестирование, которое может принимать форму интервью или других непосредственно наблюдаемых тестов юзабилити (может быть лично или с помощью инструментов видеоконференции, таких как Skype или Google Hangouts), - это поисковая работа и с целью получения большего объема информации, глубокое понимание опыта пользователя. Качественное тестирование направлено на сбор информации о жизненном опыте пользователя или группы и мотивации, чтобы увидеть, как эти данные могут повлиять на их использование продукта или инструмента.

### Результаты

При использовании методов качественных исследований важно, чтобы исследователь признавал, что они могут влиять на результаты исследований. Так как именно человеческий опыт исследуется вместо жестких данных (количество кликов, тенденции входа в систему и т. Д.), Трудно оставаться полностью объективным во время тестирования или при оценке результатов. Результаты также не обязательно будут воспроизводимыми. Это связано с тем, что факторы, которые влияют на опыт пользователя, различны и могут меняться изо дня в день. Эти факторы могут принимать форму более напряженного пользователя в один прекрасный день, чем другой, из-за новых событий в их жизни или с большим количеством обязанностей в тот день, у пользователей, имеющих совершенно другой жизненный опыт, чем у другой, плохая погода, влияющая на настроение пользователя и все остальное что влияет на личную или эмоциональную жизнь человека.

Результаты качественного тестирования обычно отображаются в виде тем или категорий вместо цифр. 1

### пример

Вот отличный пример из « [The Interaction Design Foundation»](https://www.interaction-design.org/literature/article/best-practices-for-qualitative-user-research) о разнице между количественными исследованиями и качественными исследованиями:

> Чтобы проиллюстрировать разницу, скажем, вы хотите изучить привычки упражнений группы пользователей. Вы можете изучить их с помощью количественных или качественных методов исследования. **Если вы используете _количественный_ метод** , вы можете создать онлайн-опрос и распространить его на большое количество участников. Участники должны ответить на предопределенные вопросы об их привычках упражнений, таких как «Сколько часов в неделю вы тренируетесь?». Если вы выполняете свою работу послушно, ответы на опросы можно количественно суммировать без предвзятости из вашего собственного мнения или личного опыта с упражнениями.
> 
> **Если вы используете _качественный_ метод** , вы можете делать интервью с ограниченным количеством участников, где вы говорите участникам о том, когда, где и как они тренируются. Поскольку собеседование аналогично разговору, ваши результаты будут зависеть от того, как вы зададите последующие вопросы ответам участников, и как вы это сделаете, в какой-то степени зависит от вашей индивидуальности и вашего собственного опыта с упражнениями. Точно так же результаты интервью также в некоторой степени зависят от субъективной интерпретации того, что сказал вам участник.

### Методы тестирования

Из « [12 исследовательских методик UX (количественных и качественных)](https://medium.com/ux-design-web-mobile-virtual-reality/12-ux-research-techniques-quantitative-and-qualitative-1a37bcb1914e) » Кевина Далви:

1.  **Интервью -** типично охватывает три типа интервью:

*   а) **собеседование,** где исследователь задает конкретные вопросы пользователям и пытается сравнить ответы с другими пользователями
*   б) **неориентированные интервью, в** которых исследователь пытается провести более общее обсуждение с пользователем (ами)
*   c) **этнографические интервью, в** которых исследователь наблюдает за пользователями (пользователями) в своей собственной среде, чтобы понять, как они подходят к определенным аспектам, выполнять определенные задачи.

1.  **Обзоры и** анкеты - это быстрый способ сбора информации от большого числа пользователей, но их очевидным ограничением является отсутствие какого-либо взаимодействия между исследователем и пользователями.
    
2.  **Тесты юзабилити** -инвеллирует запрос пользователю (пользователям) использовать приложение / продукт для достижения определенных целей. Существует три варианта таких тестов:
    

*   а) **умеренное тестирование -** где пользователи приводятся в лабораторию и задаются конкретные задачи или тесты для выполнения.
*   b) **немодерируемое тестирование -** где пользователи **выполняют** тест в свое время, как правило, дистанционно.
*   c) **партизанское тестирование** - более случайная форма тестирования, когда случайным пользователям в социальном или местном сообществе предлагается использовать приложение / продукт и предоставлять неофициальную обратную связь.

1.  **Карты Сорт** -The Основная цель теста карты сортировки, чтобы понять , как пользователи воспринимают отношения и иерархию между различным содержанием, категорией и другой информацией. Обычно это используется для создания соответствующей информационной архитектуры или карт сайта.
    
2.  **Тесты деревьев -** подобно сортировке карточек, основная цель - проверить, соответствует ли продукт / приложение соответствующему уровню иерархии информации в продукте.
    
3.  **A / B Tests -** фокусируется на предоставлении пользователю двух или более параметров и документирования предпочтений пользователя среди опций. Существуют также расширенные или сфокусированные тесты A / B тестов по конкретному аспекту продукта, такие как Элементы дизайна, Информационная иерархия, Навигация и многое другое.
    
4.  **Persona Development** - ... это, по сути, представление группы пользователей, которые демонстрируют очень похожую структуру с точки зрения поведения использования приложения независимо от возраста, пола, местоположения, образования и профессии.
    

### источники

1.  [Мортенсен, Дитте. «Лучшие практики для качественных исследований пользователей». _Фонд разработки взаимодействия._ Январь 2018. Доступ: 13 февраля 2018 года.](https://www.interaction-design.org/literature/article/best-practices-for-qualitative-user-research)

### Ресурсы

« [Качественные методы исследования в дизайне UX](https://www.slideshare.net/uxtalktokyo/ux-tokyo-talk-6-markus) » Маркуса Хеберлейна (презентация SlideShare, показанная на UX Tokyo Talk 2014)

« [12 методик исследования UX (количественный и качественный)](https://medium.com/ux-design-web-mobile-virtual-reality/12-ux-research-techniques-quantitative-and-qualitative-1a37bcb1914e) » Кевина Далви

« [Полное руководство для начинающих по исследованию UX](http://www.uxbooth.com/articles/complete-beginners-guide-to-design-research/) » [UX Booth](http://www.uxbooth.com/)

« [Краш-курс в UX Design Research](https://uxdesign.cc/a-crash-course-in-ux-design-research-ea00c3307c82) » Мэтта Лавуа в [UX Collective](https://uxdesign.cc/)