---
title: Modes in Vim
localeTitle: Режимы работы в Vim
---
# Режимы Vim

Поскольку Vim ориентирован на изменение существующего кода так же, как на написание нового, он разделен на несколько режимов, каждый из которых имеет разные цели.

### Обычный режим (Normal mode)

По умолчанию Vim запускается в «обычном» режиме. Доступ к обычному режиму возможен из других режимов, нажимая `Esc` или `<C-[>` .

В нормальном режиме нажатия клавиш не работают, как можно было бы ожидать. То есть они не вставляют текст в документ; вместо этого, некоторые нажатия клавиш могут:

#### Переместить курсор

*   **h** переместить один символ влево
*   **j** перемещается на одну строку вниз
*   **k** переместить одну строку вверх
*   **l** перемещайте один символ вправо

Как и многие команды vim, перемещение строк может быть префиксом числа для перемещения несколько линий за раз:

*   **4j** перемещать 4 строки вниз
*   **6k** перемещает 6 строк вверх

Основные перемещения курсора по словам:

*   **w** перейти к началу следующего слова
*   **b** перейти к предыдущему началу слова
*   **e** перейти к концу слова
*   **W** перемещается в начало следующего слова после пробела
*   **B** перейти к началу предыдущего слова перед пробелом
*   **E** перейти к концу слова перед пробелом

Начало / Конец строки:

*   **0** перемещение в начало строки
*   **$** перейти в конец строки

#### Манипулировать текстом

#### Введите другие режимы

**Обычный режим** - это то, где нужно проводить большую часть времени, используя Vim. Помните, это то, что делает Vim другим.

В обычном режиме существует несколько способов перемещения по открытому файлу. К тому же чтобы использовать клавиши курсора для перемещения, вы можете использовать `h` (слева), `j` (вниз), `k` (вверх) и `l` (справа) для перемещения. Это особенно помогает прикоснуться к машинистам, которые не нравится оставлять домашнюю строку при внесении изменений.

Вы также можете вносить изменения в одиночные символы в нормальном режиме. Например, для замените один символ, наведите курсор на него и нажмите `r` , а затем который вы хотите заменить. Аналогичным образом вы можете удалить одиночные символы перемещая курсор над ним и нажимая `x` .

Чтобы выполнить отмену, нажмите `u` в нормальном режиме. Это отменяет изменения до последнего когда вы были в нормальном режиме. Если вы хотите выполнить повтор ( _например_ , отменить отмену), нажмите `Ctrl+r` в нормальном режиме.

### Режим вставки

Это второй наиболее часто используемый режим и будет наиболее знакомым поведением для большинства людей. Как только в режиме вставки, ввод вводит символы, как обычные Текстовый редактор. Вы можете ввести его, используя команду вставки из обычного режима.

Команды вставки включают:

*   `i` для ' **i** nsert', это немедленно переключает vim в режим вставки
*   `a` для ' **a** ppend', это перемещает курсор после текущего символа и переходит в режим вставки
*   `o` вставляет новую строку под текущей строкой и вводит режим вставки на новой строке

Эти команды также имеют вид верхнего регистра:

*   `I` перемещаю курсор в начало строки и входит в режим вставки
*   `A` перемещает курсор в конец строки и переходит в режим вставки
*   `O` вставляет новую строку над текущей и вводит режим вставки на новой строке

Существует так много способов вставки текста в Vim, который не может быть указан здесь но они самые простые. Кроме того, остерегайтесь оставаться в режиме вставки слишком долго; Vim - это не предназначен для использования в режиме вставки все время.

Чтобы выйти из режима вставки и вернуться в нормальный режим, нажмите `Esc` или `<C-[>`

### Визуальный режим

Визуальный режим используется для выбора текста, подобно тому, как щелчок и перетаскивание с помощью мышь ведет себя. Выбор текста позволяет командам применяться только к выбору, например, копирование, удаление, замена и т. д.

Чтобы сделать выбор текста:

*   Нажмите `v` чтобы войти в визуальный режим, это также будет означать начальную точку выбора
*   Переместите курсор в нужную точку выбора конца; vim обеспечит визуальный выделить выделение текста

Визуальный режим также имеет следующие варианты:

*   `V` чтобы войти в режим визуальной линии, это сделает выбор текста по строке
*   `<CV>` чтобы войти в режим визуальных блоков, это сделает выбор текста блоками; перемещение курсор будет выбирать прямоугольник для текста

Чтобы выйти из режима просмотра и вернуться в обычный режим, нажмите `Esc` или `<C-[>` .

Визуальный режим фактически имеет несколько подтипов: _визуальный_ , _блок-визуальный_ и _линейно-визуальный_

*   _визуальный_ : как описано выше. Введите, нажав `v`
*   _block-visual_ : выберите любую прямоугольную область. Введите, нажав `<ctrl>+v`
*   _linewise-visual_ : всегда выбирайте полные строки. Введите, нажав `<shift>+v`

### Командный режим

Командный режим имеет широкий набор команд и может делать то, что нормальный режим не может сделать так легко. Для входа в командный режим введите ':' из нормального режима, а затем введите команду, которая должна появиться в нижней части окна. Например, чтобы выполнить глобальный поиск и замену типа `:%s/foo/bar/g` для замены все 'foo' с 'bar'

*   `:` Вход в командный режим
*   `%` Средства по всем линиям
*   `s` Заменители
*   `/foo` - это регулярное выражение, чтобы найти вещи для замены
*   `/bar/` является регулярным выражением, чтобы заменить
*   `/g` означает глобальный, иначе он будет выполняться только один раз в строке

У Vim есть ряд других методов, о которых вы можете прочитать в справке документация `:h` или `:help` .

### Режим замены

Режим замены позволяет заменить существующий текст, непосредственно набрав его. Перед тем, как войти в этот режим, войдите в нормальный режим и поместите курсор поверх первого символа, который вы хотите заменить. Затем нажмите «R» (столица R) на войдите в режим замены. Теперь все, что вы напечатаете, заменит существующий текст. курсор автоматически переходит к следующему символу, как в режиме вставки. разница только в том, что каждый персонаж, который вы набираете, заменит существующий.
