---
title: Motions
localeTitle: Ходатайства
---
# Vim Basic Motions

### Движения курсоров

Сначала в VIM мы можем использовать клавиши со стрелками, если нам нравится перемещаться по текстовому файлу, но это не лучший способ сделать это, и мы потеряли преимущество коммандных команд, которые предоставляет VIM.

Вместо этого по умолчанию и наилучшим способом перемещения по тексту используются клавиши `h` (слева), `j` (вниз), `k` (вверх) и `l` (справа).
```
     ^ 
     | 
     k 
 <- h   l -> 
     j 
     | 
     v 
```

Преимущество использования этих клавиш вместо клавиш со стрелками заключается в том, что вы можете комбинировать движения с другими командами, например:

*   `d2j` -> удалить 2 строки вниз
*   `y10k` -> копировать 10 строк вверх
*   `10l` -> переместить 10 символов вправо
*   `2h` -> переместить 2 символа влево

### Слова

Слово состоит из последовательности букв, цифр и символов подчеркивания или последовательность других непустых символов, разделенных пробелом (пробелы, вкладки, конец строки). Пустая строка также считается словом.

Это можно переместить с помощью этих commnads:

*   `w` -> перейти к следующему слову
*   `W` -> перейти к следующему **WORD** \*
*   `e` -> перейти к концу следующего слова
*   `E` -> перейти в конец следующего **СЛОВА**
*   `b` -> перейти к предыдущему слову
*   `B` -> перейти к предыдущему **WORD**
*   `ge` -> перейти к концу предыдущего слова
*   `gE` -> перейти в конец предыдущего **WORD**

\* **WORD** состоит из последовательности непустых символов, разделенных белым пространство. Пустая строка также считается **WORD** , то есть: `quux(foo,` `bar,` `foo);`

С помощью этих движений в сочетании с другими командами вы можете делать такие вещи, как:

*   `dw` -> удалить слово
*   `5e` -> перейти к концу 5-го слова отсюда

### Поисковые запросы

Другой способ перемещения по интересующей вас позиции - это использование поисковых движений, поисковые движения состоят в движение + символ для поиска

*   `fx` -> перейти к следующему `x`
*   `tx` -> перейти к первой позиции до следующего `x`
*   `;` -> следующий x
*   `Fx` -> перейти к предыдущему `x`
*   `Tx` -> перейти в первую позицию после предыдущего `x`
*   `,` -> предыдущий x

### Начало и конец строк

Вы также можете перейти к началу или концу строки с помощью VIM, с помощью следующих команд:

*   `0` -> Начало строки
*   `^` -> Первый нечерный символ линии
*   `$` -> Конец строки

### Движения файлов

В VIM вы можете перемещаться по файлу с помощью следующих команд:

*   `gg` -> перейти в первую строку файла
*   `G` -> перейти к последней строке файла
*   `<ctrl> + f` -> переместить одну страницу вниз
*   `<ctrl> + b` -> переместить одну страницу вверх
*   `/text` -> найти `text`
*   `n` -> перейти к следующему вводу `text` (предыдущая команда)
*   `?text` -> найти предыдущий `text`
*   `N` -> перейти к предыдущему вложению `text`
*   `{` -> переместить один абзац вверх
*   `}` -> переместить один абзац вниз
*   `(` -> переместить одно предложение вверх
*   `)` -> переместить одно нажатие вниз
*   `#` -> найти слово под курсором вверх
*   `*` -> найти слово под курсором вниз