---
title: Navigation
localeTitle: навигация
---
## Навигация по файлу в Vim

### Основные движения

Есть много способов перемещения курсора в Vim, но эти основные движения позволят новым пользователям комфортно использовать обычный режим для навигации по файлам.

*   В нормальном режиме (после одноразового нажатия `Esc`) клавиши `h` , `j` , `k` , `l` соответствуют перемещению курсора один символ налево, вниз, вверх и направо соответственно.
    
*   Чтобы перемещаться по словам, клавиши `w` и `b` помогут перемещать курсор до начала следующего слова или до начала предыдущего слова. Клавиша `e` переместит курсор до конца текущего слова.
    
*   Чтобы перейти к началу текущей строки, введите `0` и для перемещения до конца текущей строки, введите `$` (`shift+4`) .
    
*   Наконец, чтобы перейти к самой первой строке файла, введите `gg` и для того чтобы перейти до конца всего файла нажимайте `G` (`shift+g`).
    

Краткий обзор:

```vim
 h   перемеcтить курсор одним симболом налево
 j   перемеcтить курсор одной строкой вниз
 k   перемеcтить курсор одной строкой вверх
 l   перемеcтить курсор одним симболом направо
 
 w   перемеcтить курсор до начала следующего слова
 b   перемеcтить курсор до начала предыдущего слова
 e   перемеcтить курсор до конца текущего слова
 
 0   перемеcтить курсор до начала текущей строки
 $   перемеcтить курсор до конца текущей строки
 :n  перемеcтить курсор до линии `n` (т.е. :23 двигает курсор до линии 23) так же можно использовать `nG` 
 
 ZZ  перемеcтить курсор в центр строки
 H   перемеcтить курсор до начала экрана
 M   перемеcтить курсор до середины экрана
 L   перемеcтить курсор до конца экрана
 
 gg  перемеcтить курсор до первой строки файла
 G   перемеcтить курсор до последней строки файла

```
