---
title: Search and Replace
localeTitle: Поиск и замена
---
# Поиск и замена в Vim

Поиск и замена в vim будет искать все экземпляры заданного шаблона текста и заменять его строкой.

### Командные клавиши

Команды, используемые для поиска и замены:

*   `:substitute`
*   `:s` (сокращенная сокращенная форма замены)

### Структура команды

Структура, используемая для поиска и замены:

`:[range]` `s` / `[pattern]` / `[string]` / `[flags]` `[count]`

где…

*   `[range]` указывает строки для поиска (например, `1` : первая строка, `$` : последняя строка, `%` : все строки).
*   `[pattern]` - это шаблон текста для поиска.
*   `[string]` - строка, которая заменит шаблон текста.
*   `[flags]` включить дополнительные опции поиска и замены (например, `c` : подтвердить подстановку, `g` : заменить все вхождения в каждой строке, `i` : игнорировать).
*   `[count]` заменяет строки `[count]` начиная с последней строки в `[range]` (или текущей строки, если `[range]` опущен).

### Общие примеры

Ниже приведены некоторые общие примеры поиска и замены:

*   `:s/foo/bar/` Измените первое «foo» на «bar» в текущей строке.
*   `:s/foo/bar/g` Измените каждый «foo» на «bar» в текущей строке.
*   `:%s/foo/bar/g` Измените каждый «foo» на «bar» во всех строках.
*   `:13s/foo/bar/g` Измените каждый «foo» на «bar» в строке 13.
*   `:%s/foo/bar/cgi` Измените каждый «foo» на «bar» во всех строках.