---
title: Useful Commands
localeTitle: Полезные команды
---
# Полезные команды

## Основные функции

Скорее всего, вы окажетесь в «нормальном» режиме, он позволяет вводить команды, нажимая клавишу двоеточия `:` Чтобы перейти из других режимов, вы можете ввести `ctrl + c` или `escape` .

Чтобы отредактировать текст и передвигаться знакомым способом, нажмите `i` для режима «вставки». Попробуйте передвигаться с помощью клавиш со стрелками в режиме «вставки» - подробности см. В разделе «Навигация» ниже.

В зависимости от конфигурации вы можете ввести браузер файлов, введя и введя команду `:e .` в «нормальном» режиме. «E» означает редактирование, а также период для файла или каталога.

## навигация

*   Движение курсора: вы можете использовать клавиши со стрелками или `h` , `j` , `k` , `l` (влево, вниз, вверх, вправо)
*   `gg` приводит вас к началу файла
*   `G` приводит вас к концу файла
*   `:(num)` приводит вас к определенной строке в вашем файле (например: 42 приводит вас к строке 42)

## экономия

1.  Нажмите `Escape` чтобы убедиться, что вы находитесь в `normal mode` ;
2.  Введите `:w` («w» означает «write»);
3.  Нажмите `Enter` .

## Сохранение (в новый файл)

1.  Нажмите `Escape` чтобы убедиться, что вы находитесь в `normal mode` .
2.  Введите `:w newfilename` (newfilename - имя файла нового файла, который вы хотите сохранить).
3.  Нажмите `Enter` .

## Выход из Ви, Вима, Нвима, Гвима

1.  Нажмите escape, чтобы перейти в «обычный» режим
2.  `:q` будет мягким выйти из vim
3.  `:q!` заставит выйти из vim
4.  `:qa` это закрывает все открытые файлы
5.  `:qa!` закрывает все файлы, оставляя изменения
6.  `:q` сохраняет и закрывает текущий файл

(ПРИМЕЧАНИЕ: Команда `:q!` Заставит Vim выйти без сохранения. Обязательно сохраните сначала, набрав команду `:w` если вы не хотите терять какие-либо изменения, которые вы сделали.)

**ИЛИ**

*   Тип ZZ (сохранение и выход)
*   Тип `:wq` / `:x` (сохранение и выход, но использование с использованием обычно используемых команд «w» и «q»)

## Вырезать, скопировать и вставить

*   `dd` удаляет (сокращает) одну строку
*   `yy` yanks (копии) одной строки
*   вы можете использовать `yy` и `dd` предшествует число, чтобы вырезать или скопировать несколько строк (ex- `13dd` сократит 13 строк)
*   `p` вставляет все из буфера

## Вставка блоков кода

Очень часто вы обнаружите, что ищете решения проблем, и найти кого-то написал блок кода, который делает именно то, что вы хотите. Если вы попытаетесь скопировать и вставить код непосредственно в Vim, вы можете обнаружить, что код странно отформатирован или не был вставлен правильно. Это связано с тем, что Vim читает каждый символ, который вы вставляете один за другим, что означает, что будут выполняться любые комбинации клавиш, которые активируют ярлык Vim, и Vim будет пытаться (и отказываться) автоматически отступать от вставленного кода.

Чтобы преодолеть это, вы можете использовать **режим вставки** Vim, который вы можете активировать, введя нормальный режим (нажмите `escape` или `crtl + c` ) и введите `:set paste` , затем нажмите ENTER. Теперь вы находитесь в режиме _вставки_ . Затем вы можете войти в режим вставки с `i` и вставить блок текста / кода без каких-либо проблем! Чтобы вернуться в обычный режим Vim без вставки, вы можете войти в обычный режим ( `escape` или `crtl + c` ) и ввести `:set nopaste` и нажать ENTER.

## Установка номеров линий

1.  Нажмите escape, чтобы перейти в «обычный» режим
2.  Тип `:set number` , нажать enter

Чтобы установить номера строк по умолчанию:

1.  Откройте / создайте конфигурационный файл `vim ~/.vimrc` с помощью `vim ~/.vimrc`
2.  Добавьте `set number` строк, нажмите enter

## Открытие файла в VIM

В VIM вы можете открыть файл в том же окне, установив курсор на путь и набрав `gf` . Это сообщит VIM, что текущий текст, который находится курсором, является файлом, который вы хотите открыть. Файл откроется внутри терминала VIM, поэтому, если вы хотите вернуться в предыдущее окно, просто введите `ctrl+o` . Это позволит VIM перейти к предыдущему экрану.

## Как разделить окна

Вы можете разделить окна vim и одновременно редактировать 2 или более файлов.

*   `:split` -> split window (горизонтальное)
*   `:vsplit` -> разделенное окно (вертикальное)
*   `:vertical` new -> открыть новый файл в новом окне

Для перемещения между окнами вы можете использовать следующие команды:

*   `CTRL-W h` - перейти в окно слева
*   `CTRL-W j` - перейти к окну ниже
*   `CTRL-W k` - перейти к окну выше
*   `CTRL-W l` - переход в окно справа
*   `CTRL-W t` - переход в верхнее окно
*   `CTRL-W b` - переход в нижнее окно

## Отменить повторить

Эти действия должны выполняться в **обычном режиме** .

**Отменить** : нажмите `u` или введите `:undo` и нажмите `Enter` .

**Повторить** : Нажмите `U` ( `Shift` + `u` ) или введите `:redo` и нажмите `Enter` .

## Открытие файла в определенной строке

*   vi filename + n, где n - номер строки

## Открытие файла, ищущего слово / срок

*   vi filename + / word, где слово - это то, что вы ищете. Курсор будет располагаться при первом появлении слова.

## Поиск файла в Vim

В нормальном режиме (нажмите клавишу `escape` чтобы убедиться), вы можете искать любой термин в документе, введя `/` , затем следуя термину, который вы ищете, а затем нажмите `enter` . Например, введите `/hello` и нажмите `enter` чтобы найти слово «hello» в текущем файле.

Вы можете перейти к следующему появлению вашего поискового запроса, нажав `n` или предыдущее вхождение, нажав `N` `*` ищет слово под курсором.

Если вы хотите выделить все типы совпадений поиска `:set hlsearch` или используйте сокращенную команду `:set hls` . Используйте `:set noh` чтобы отключить подсветку до следующего поиска.

## Компиляция проекта

Vim имеет очень тесную интеграцию с `make` инструментом автоматизации сборки. Если ваш проект использует Makefile, вы можете ввести `:make` в командной строке Vim, чтобы запустить инструмент `make` вашей системы. Vim распечатает вывод `make` на экране и доведёт до первой ошибки, если таковая имеется, когда команда `make` завершена. Затем вы можете перейти через ошибки компиляции и предупреждения в код вашего проекта, используя команды `:cn` и `:cp` для следующих и предыдущих проблем соответственно.

## Найти и заменить

1.  Нажмите `Escape` чтобы убедиться, что вы находитесь в `normal mode` ;
2.  Введите `:` (вы переключитесь в `command mode` );
3.  Введите `%s,word_to_be_replaced,new_word,g` ;
4.  Нажмите `ENTER` .

Важно: если вы хотите заменить первое появление слова, удалите `g` в конце.

## Я хочу узнать Vim!

Для начинающих, Vim имеет встроенный учебник! Вы можете получить к нему доступ, запустив `vimtutor` с вашего терминала, и это запустит интерактивный учебник о _том, как начать работу с Vim_ (требуется около 15 минут для работы).

Если вы не так уверены в английском, вы можете позволить себе `vimtutor` на вашем языке выбора. Например, `vimtutor fr` запустит учебник на французском языке!

## Другие полезные команды

*   `gg=G` фиксирует отступ всего файла
*   Если вы хотите узнать больше о конкретной команде, введите `:help` а затем имя команды (ex-: help: w)

Прочтите остальные наши Vim Guides, чтобы лучше понять этот мощный редактор.

## Другие источники

*   [Vim Golf](https://vimgolf.com/) - хороший способ научиться делать vim-вызовы, чтобы получить наименьшее количество нажатий клавиш. Вы можете видеть решения, представленные другими, если вы не можете понять вызов.
*   [Vim Adventures](https://vim-adventures.com/) - забавный и увлекательный подход к изучению Vim, где вы можете разыгрывать различные штрихи с каждым новым уровнем в игре.
*   [Open Vim](http://www.openvim.com/) - интерактивный учебник vim, в котором описываются основные команды