---
title: Color Theory
localeTitle: Теория цвета
---
## Теория цвета

Color Theory - это практическое применение смешивания цветов и использования цвета для достижения определенного визуального эффекта.

Цвета используются разными способами.

Выбор цветов на визуальном дисплее часто ограничивается аппаратным обеспечением, программным обеспечением, работающим на аппаратном обеспечении, ограничениями человеческого глаза и вариациями на то, как люди воспринимают цвет.

Ограничения на выбор также определяются искусственными ограничениями, предоставляемыми проектом, такими как необходимость соответствовать стилю дизайна и брендингу.

Цветовое колесо является основным инструментом, используемым дизайнерами для указания или определения цвета. Цветные колеса могут включать весь спектр цветов, или они могут быть организованы определенной категорией цветов.

Четыре основные категории цветов, с которыми вы, возможно, уже знакомы, - это первичные цвета, вторичные цвета, третичные цвета, дополнительные цвета.

Использование теории цвета может помочь удовлетворить требованиям проектов, максимально увеличивая разборчивость текста и доступность контента для зрителей с различными особенностями или потребностями просмотра.

### Цветное колесо или выбор цвета

Цветовое колесо или сборщик - это инструмент, используемый дизайнерами для указания или определения цвета. Сборщики цветов могут включать цветовой спектр, или они могут быть организованы определенными категориями света, такими как яркость и оттенок.

**Первичные цвета**

В искусстве и иллюстрации цвета традиционно разделены на три категории: первичные цвета, вторичные цвета и третичные цвета. Первичные цвета - это цвета, которые нельзя смешивать или формировать с помощью любой комбинации других цветов. Вторичные цвета - это те, которые формируются путем смешивания двух основных цветов. Третичные цвета - это те, которые формируются путем смешивания всех трех основных цветов.

В традиционной живописи цвета - красный, желтый и синий (RYB). Все остальные цвета получены из этих трех. Фактический оттенок каждого основного цвета влияет на диапазон доступных цветов.

Компьютерные визуальные дисплеи обычно используют другой набор из трех основных цветов для приближения цвета: красный, зеленый и синий (RGB). Каждый отображаемый цвет сделан из-за изменения яркости основных цветов.

Компьютерные принтеры обычно используют четыре основных цвета для представления цвета. Черный цвет иногда используется в качестве контрастного вещества для увеличения диапазона контрастности. Комбинация первичных цветов: голубой, пурпурный, желтый и ключ (CMYK) является обычным явлением. «Ключ» представляет черный. Ключ - традиционный термин для наиболее впечатляющего впечатления от комбинации отпечатков.

### Цветная психология

Цветная психология - это исследование того, как цвет влияет на настроение и поведение человека. Цвета, выбранные для дизайна, могут влиять на успешный продукт.

**Дополнительные цвета:** Красно-зеленый, желто-фиолетовый, сине-оранжевый Это цвета, образованные путем смешивания цветов, которые являются oppsite друг от друга на цветном колесе.

В веб-дизайне цвета также несут с собой коннотации и последствия, которые необходимо понимать, иначе вы можете вызвать путаницу. Красный цвет в нецифровом пространстве, например, ресторан быстрого питания, несет в себе энергию или волнение. Тем не менее, в Интернете красный цвет также несет в себе следование, что пользователь совершил ошибку. Этот пример того, как цвет означает определенные вещи в определенных настройках, должен быть важным напоминанием, чтобы понять, как человек, просматривающий вашу страницу, будет интерпретировать выбранный вами цвет.

### Веб-цвета

Веб-стандарты, включая HTML, CSS и графические форматы файлов: jpeg, PNG, GIF и SVG используют основные цвета красного, зеленого и синего. Каждая технология или устройство отображает немного другой оттенок основного цвета. Например, чистый красный на одном мониторе может выглядеть более розовым или оранжевым на другом. Эти отклонения дополняют сложность попыток изобразить точные цвета на экране компьютера. Это серьезная проблема, например, при попытке:

*   представляют продукт с определенным цветовым оттенком или
*   представляют собой радугу цвета или
*   предупреждать пользователя сообщениями различной степени важности.

Эвристика веб-дизайна, рекламы и человеко-компьютерного интерфейса также признает, что цвета несут культурные коннотации и последствия.

[Это руководство по быстрому стилю поможет вам принять ваш запрос на тягу](https://github.com/freecodecamp/guides/blob/master/README.md) .

#### Дополнительная информация:

[Основная таблица цветов](http://lfhs.lfcisd.net/UserFiles/Servers/Server_904/File/ECCastillo/Color%20Theory%20Worksheet.pdf)

[Викиреальность](https://en.wikipedia.org/wiki/Color_psychology)

[Таблица спектральных или ближних спектральных цветов в RGB](https://en.wikipedia.org/wiki/Spectral_color#Table_of_spectral_or_near-spectral_colors)

[Цвет и удобство использования](/visual-design/color-theory/usability/index.md)

[Цвет и культура](/visual-design/color-theory/color-and-culture/index.md)

[Как получить профессиональный вид с цветом](https://www.webdesignerdepot.com/2009/12/how-to-get-a-professional-look-with-color/)

[Его единственный цвет](https://robots.thoughtbot.com/Its-only-color)