---
title: Voice
localeTitle: голос
---
## голос

Распознавание речи позволяет пользователям, испытывающим трудности с доступом (например, постоянное ухудшение зрения или временное ухудшение во время движения), возможность навигации по содержимому веб-сайта или ввода текстовых данных (например, формы).

Синтез речи предоставляет веб-сайтам возможность предоставлять информацию пользователям, читая текст.

### API веб-речи Javascript

[Web Speech API](https://developer.mozilla.org/en-US/docs/Web/API/Web_Speech_API) позволяет вам включать голосовые данные в веб-приложения, используя как распознавание речи, так и синтез речи.

#### Как работает API Web Speech

API WebSpeech использует собственную микрофонную систему устройства. Когда высказывание распознается из предопределенной грамматики (см. Ниже), оно возвращается как результат (или список результатов) в виде текстовой строки, а функции обратного вызова могут предоставляться для выполнения дальнейших действий.

#### Как использовать API SpeechRecognition

Вот простой пример использования SpeechRecognition API. Обратите внимание, что API запускается с `new SpeechRecognition()` и начинается с `recognition.start();` называется. Он создает транскрипт из того, что получено, а затем добавляется к элементу `<p class="transcript">` . [Нажмите здесь, чтобы получить рабочую демонстрацию этого кода](https://codepen.io/ashwoodall/pen/MPeyRm) .

Это HTML, к которому добавляется расшифровка:

```html

<main class="main"> 
  <span class="loader"></span> 
  <p class="description">What I think you said: <p class="transcript" data-js="varValue"></p></p> 
 
 </main> 
```

И вот JavaScript:

```javascript
window.SpeechRecognition = window.SpeechRecognition || window.webkitSpeechRecognition; 
 
 const span = document.querySelector('[data-js="varValue"]'); 
 const main = document.querySelector('.main'); 
 const loader = document.querySelector('.loader'); 
 
 const recognition = new SpeechRecognition(); 
 recognition.lang = 'en-US'; 
 
 recognition.addEventListener('result', e => { 
    const transcript = Array.from(e.results) 
        .map(result => result[0].transcript) 
 
    span.textContent = transcript; 
    loader.textContent = ''; 
 }); 
 
 recognition.addEventListener('start', () => loader.textContent = 'Listening (enable your microphone)...'); 
 
 recognition.addEventListener('end', recognition.start); 
 recognition.start(); 
```

### Alexa

Alexa - это голосовой сервис Amazon для облачных вычислений, доступный на десятках миллионов устройств от Amazon и сторонних производителей устройств. С Alexa вы можете создать естественный голос, который предлагает клиентам более интуитивный способ взаимодействия с технологией, которую они используют каждый день. Он способен к голосовому взаимодействию, воспроизведению музыки, составлению списков дел, настройке сигналов тревоги, потоковым подкастам, воспроизведению аудиокниг и предоставлению информации о погоде, трафике, спорте и другой информации в режиме реального времени, такой как новости.

# Amazon Echo Device Range

*   Amazon Echo
*   Amazon Echo Plus
*   Amazon Echo Dot
*   Amazon Echo Look
*   Amazon Echo Show
*   Amazon Echo Spot

# Фарфоровые микрофоны

Системы распознавания речи часто используют несколько микрофонов для уменьшения воздействия реверберации и шума. Эхо-микрофоны расположены в гексагональной компоновке с одним микрофоном в каждой вершине и одной в центре. Задержка между каждым микрофоном, принимающим сигнал, позволяет устройству идентифицировать источник голоса и отменять шум, исходящий из других направлений. Это явление известно как формирование луча.

В то время как современные системы распознавания речи достаточно хорошо работают в условиях микрофона с близким разговором, производительность ухудшается в условиях, когда микрофон находится далеко от пользователя.

Звук, захваченный эхом, будет зависеть от: 1) голос говорящего о стену комнаты, 2) фоновый шум снаружи, 3) акустический эхосигнал, поступающий от громкоговорителя устройства 4) выходной звук на стену комнаты.

# Программного обеспечения

Программные компоненты на платформе включают в себя как Natural Language Understanding (NLU), так и автоматизированное распознавание речи (ASR). Эти программные компоненты могут быть задействованы специальными письменными «навыками» независимыми разработчиками программного обеспечения, которые затем сертифицированы по ряду стандартов Amazon. В магазине приложений уже есть более 20 тысяч этих пользовательских навыков.

### IBM Watson Speech-to-Text API

IBM Watson Speech-to-Text использует машинное обучение для точного прогнозирования речи в реальном времени. В настоящее время поддерживается семь разных языков, а также живой голос и предварительно записанный звук. API можно использовать бесплатно, или платные версии доступны для приложений большего масштаба.

### Больше информации

[API веб-речи](https://developer.mozilla.org/en-US/docs/Web/API/Web_Speech_API) [Alexa API](https://developer.amazon.com/docs/alexa-voice-service/api-overview.html) [API IBM Watson](https://www.ibm.com/watson/services/speech-to-text/)