---
title: Components
localeTitle: Компоненты
---

## Компоненты

Классическая проблема веб девелоперов - работа с HTML дупликатами, но не как в 
простом примере со списком, иногда тебе просто нужно импортировать один и тот же
код в разные места. Vue.js дает вам эту возможность благодаря компонентам.

Представим вы разрабатываете landing page для продукта вашей компании и вам нужно
отобразить 4 его главных приемущества в одинаковом стиле, например карточек, с иконкой,
заголовком и небольшим описанием.

```javascript
Vue.component('feature-card', {
  props: ["iconSrc", "iconAltText", "featureTitle", "featureDescription"],
  template: `
    <div class="card">
      <div class="icon-wrapper">
        <img
          class="icon"
          :src="iconSrc"
          :alt="iconAltText">
      </div>
      <h4 class="title">
        {{ featureTitle }}
      </h4>
      <p class="description">
        {{ featureDescription }}
      </p>
    </div>
  `
});
```

> Заметьте что мы использовали синтаксис ':src' для атрибута 'src'.
Это ничего не меняет, это просто сахар и означает он следующее 'v-bind:src' -- 
когда вы ходите забиндить атрибут к переменной вы можете заменить 'v-bind:' на ':'

В этом снипете мы сделали много нового:
* мы создали новый компонент с названием 'feature-card'
* мы определили основную **структуру** компонента 'feature-card' с помощью атрибута 'template'
* мы описали список свойств которые примет компонент из списка 'props'

Так как мы определили имя компонента, как только мы захотим использовать его еще раз,
мы можем ссылаться на него используя его тэг. В нашем примере мы можем использовать тэг '<feature-card>':

```html
<div id="app">
  <feature-card
    iconSrc="https://freedesignfile.com/upload/2017/08/rocket-icon-vector.png"
    iconAltText="rocket"
    featureTitle="Processing speed"
    featureDescription="Our solution has astonishing benchmarks grades">
  </feature-card>
</div>
```

В этом случае, мы вызвали '<feature-card>', как будто такой тэг существует, 
установили 'iconSrc' и 'featureTitle' как будто это валидные атрибуты.
Предназначение Vue.js компонентов: дать вам возможность писать свои инструменты.

### Входные параменты или Props

Входные параметры это кастомные атрибуты, которые вы можете зарегистрировать в компоненте. Когда значение передается во входной параметр, он становится свойством в этом компоненте. Чтобы передать заголовок в пост нашего блога, мы можем включить его в лист входных параметров, которые принемает этот компонент, используя действие 'props':

```js
Vue.component('feature-card', {
  props: ['title'],
  template: '<h3>{{ title }}</h3>'
})
```
Компонент может иметь сколько угодно входных параментов, любое значение может быть передано в любой входной параметр. В шаблоне выше, вы можете увидеть как мы может получить доступ к этим значениям, точно так же как и с 'data'.

Как только входной параметр зарегестрирован, вы можете передавать в него данные используя кастомный атрибут, вот так:
```html
<blog-post title="My journey with Vue"></blog-post>
<blog-post title="Blogging with Vue"></blog-post>
<blog-post title="Why Vue is so fun"></blog-post>
```
