---
title: Control Flow
localeTitle: Поток управления
---
## Поток управления

### Conditionals

С Vue.js вы можете решить, хотите ли вы показать или нет фрагмент кода в финале страница, в зависимости от этого состояние. Например, представьте, какой ввод формы требуется текст длиной не менее 8 символов: если ввод пользователя короче 8, чем должно появиться сообщение об ошибке; но если входной сигнал длиннее 8, сообщение исчезает.

Но давайте сделаем более простой пример. Мы хотим условиться об экспонировании сообщение счетчику:

```html

<div id="app"> 
  <p v-if="counter > 10"> 
    This message is only rendered when the counter is greater than 10 
  </p> 
 </div> 
```

```javascript
let app = new Vue({ 
  el: '#app', 
  data: { 
    counter: 0 
  } 
 }); 
```

Если вы перейдете на консоль и начнете увеличивать счетчик, когда он пересекает наш порог 10, сообщение будет показано! Затем, если вы уменьшаете `counter` , Vue.js скроет сообщение, когда `counter` станет ниже 10. Для этого мы использовал директиву `v-if` .

И вам может быть интересно, есть ли для этого `else` что- `if` . И есть `v-else` . Обратите внимание, что `v-else` всегда будет

*   ожидать `v-if` до этого
*   относится к ближайшему `v-if` на странице

Давайте немного изменим наш первый пример, чтобы получить это прямо.

```html

<div id="app"> 
  <p v-if="counter > 10"> 
    This message is only rendered when the counter is greater than 10 
  </p> 
  <p v-else> 
    And this is the "otherwise" option 
  </p> 
 </div> 
```

```javascript
let app = new Vue({ 
  el: '#app', 
  data: { 
    counter: 0 
  } 
 }); 
```

Поиграйте немного с этим, изменив значение `counter` и обратите внимание на сообщение показано.

Vue.js также имеет директиву `v-else-if` .

### Циклы

Vue.js так же помогает с созданием множества копий элементов с помощью директивы 'v-for'. Классический пример - динамическая отрисовка списка.

```html

<div id="app"> 
  <ul> 
    <li v-for="item in list"> 
      {{ item }} 
    </li> 
  </ul> 
 </div> 
```

```javascript
let app = new Vue({ 
  el: '#app', 
  data: { 
    list: [ 
      "shave", 
      "do the dishes", 
      "clean the sink", 
      "pay the bill" 
    ] 
  } 
 }); 
```

Гораздо проще чем копирование большого количества '<li>'. Обратите внимание, что всякий раз, когда массив 'list' изменяется, результат изменяется соответствующим образом. Пропробуйте открыть консоль и добавить новую строку в массив 'items'.

```javascript
app.list.push("something else"); 
```

Как и ожидалось, на странице появится новый элемент!

### Получение доступа к итератору

`v-for` так же поддерживает второй аргумент(опционально). Этот аргумент является порядковым номером элемента в массиве 'items':

```html
<div id="app">
  <ul>
    <li v-for="(item, index) in items">
      {{ index }}: {{ item }}
    </li>
  </ul>
</div>
```
Таким образом мы можем использовать 'index', чтобы стилизовать первый, последний или четный/нечетный элемент списка по разному, а так же добавить дополнительную логику к нашему компоненту.
