---
title: Web Components
localeTitle: Веб-компоненты
---
## Что такое веб-компоненты?

Веб-компоненты состоят из серии веб-спецификаций, созданных [W3C](https://w3c.github.io/) . Эти спецификации описывают набор API-интерфейсов веб-платформы, которые могут использоваться для создания многоразовых, инкапсулированных и настраиваемых HTML-элементов. Предоставляя веб-интерфейсы низкого уровня, используемые поставщиками браузеров для создания HTML-элементов, которые, возможно, уже знакомы, веб-компоненты могут использоваться различные среды. Это означает, что вы работаете на сайте Wordpress, приложении, создаваемом сервером, в приложении с одной страницей (SPA) с новейшей инфраструктурой или вообще без фреймворка, можно использовать веб-компоненты. Впервые, независимо от того, какая структура используется, вы можете понять, что Интернет является платформой для создания уникальных событий, которые легко переводится с одной платформы на другую.

## Спецификации веб-компонентов

Веб-компоненты определены в [четырех основных спецификациях](https://www.webcomponents.org/introduction#specifications) .

*   **Пользовательские элементы**
    
*   Спецификация [Custom Elements](https://w3c.github.io/webcomponents/spec/custom/) лежит в основе разработки и использования новых типов элементов DOM.
    
*   **Тень DOM**
    
*   Спецификация [Shadow DOM](https://w3c.github.io/webcomponents/spec/shadow/) определяет, как использовать инкапсулированный стиль и разметку в веб-компонентах.
    
*   **Модули ES**
    
*   Спецификация [модулей ES](https://html.spec.whatwg.org/multipage/webappapis.html#integration-with-the-javascript-module-system) определяет включение и повторное использование JS-документов в стандартном, модульном, исполнительном режиме.
    
*   **Шаблон HTML**
    
*   Спецификация [элемента HTML-шаблона](https://html.spec.whatwg.org/multipage/scripting.html#the-template-element/) определяет, как объявить фрагменты разметки, которые не используются при загрузке страницы, но могут быть созданы позже во время выполнения.
    

### Дополнительная информация:

*   [Введение в веб-компоненты](https://www.webcomponents.org/introduction)
*   [Расширяемый веб-манифест](https://github.com/extensibleweb/manifesto)
*   [Спецификация веб-компонентов W3C](https://w3c.github.io/webcomponents/explainer/)