---
title: Unconscious Bias
localeTitle: Бессознательное смещение
---
## Бессознательное смещение

Предвзятость является предрассудком в пользу или против одной вещи, человека или группы по сравнению с другим, как правило, таким образом, который считается несправедливым. Уклонения могут проводиться отдельным лицом, группой или учреждением и могут иметь отрицательные или положительные последствия. По этой причине преимущества пресудизма могут существовать только за счет других. Поэтому, чтобы быть «предвзятым», вы должны быть «предвзятым».

Бессознательное предубеждение, иначе известное как «неявное уклонение», происходит, когда люди предпочитают других, которые похожи на них, и / или разделяют их ценности. Например, лицо может быть привлечено к тому, у кого есть аналогичный образовательный фон, из той же области, которая имеет сходную сексуальную ориентацию или имеет тот же цвет или этническую принадлежность, что и они.

Неявное или бессознательное смещение происходит с помощью наших мозгов, делая невероятно быстрые суждения и оценки людей и ситуаций, не осознавая нас. На наши предвзятости влияет наш фон, культурная среда и личный опыт. Мы можем даже не знать об этих взглядах и мнениях или быть в курсе их полного воздействия и последствий. 3

Бессознательное предубеждение гораздо более распространено, чем сознательное предубеждение и часто несовместимо с сознательными ценностями. Некоторые сценарии могут активировать бессознательные отношения и убеждения. Например, смещения могут быть более распространенными при многозадачности или работе под временным давлением. 4

Если вы работаете в [гибридной удаленной команде,](https://github.com/freeCodeCamp/guides/src/pages/working-in-tech/remote-versus-onsite/index.md) тогда может быть бессознательное смещение в игре в зависимости от того, где кто-то сидит. Например, люди физически болтают с коллегами (буквальный «кулер воды») по-другому, как они это делают через Slack. Сильные команды и руководители знают об этом и предпочитают [следить за некоторыми протоколами,](https://viewpoints.matrixpartners.com/how-to-support-remote-work-by-removing-unconscious-bias-7a974f953410) чтобы минимизировать его последствия.

#### Project Implicit:

Есть много факторов, которые могут дать вам необоснованное предубеждение, например:

*   Наше восприятие - как мы видим людей и воспринимаем реальность.
*   Наше отношение - как мы реагируем на определенных людей.
*   Наши Поведения - насколько восприимчивы мы к определенным людям.
*   Наше внимание - какие аспекты человека мы уделяем больше всего внимания.
*   Наши навыки слушания - насколько мы активно слушаем то, что говорят некоторые люди.
*   Наши микроаффирмации - насколько или как мало мы утешаем определенных людей в определенных ситуациях.

В различных исследованиях также было установлено, что даже порядок вопросов в тесте может привести к бессознательному уклону. Существует очень хорошее видео на эту тему [здесь](https://www.youtube.com/watch?v=75g4d5sF3xI) .

Бессознательное предубеждение гораздо более распространено, чем сознательное предубеждение и часто несовместимо с сознательными ценностями. Некоторые сценарии могут активировать бессознательные отношения и убеждения. Например, смещения могут быть более распространенными при многозадачности или работе под временным давлением.

Бессознательное предубеждение может влиять на решения по набору, продвижению и управлению производительностью. Это может быть дискриминационным, когда бессознательное смещение относится к защищенной характеристике.

#### Дополнительная информация:

1.  [Наварро, Рене М.Д. «Что такое бессознательное предубеждение?» _Калифорнийский университет, Сан-Франциско._ Доступ: 20 октября 2017 г.](https://diversity.ucsf.edu/resources/unconscious-bias)
2.  [«Бессознательное смещение». _Консультативная, примирительная и арбитражная служба._ Доступ: 20 октября 2017 г.](http://www.acas.org.uk/index.aspx?articleid=5433)
3.  [«Бессознательное смещение». _Равенство._ Доступ: 20 октября 2017 г.](https://www.ecu.ac.uk/guidance-resources/employment-and-careers/staff-recruitment/unconscious-bias/)
4.  [«Что такое бессознательное смещение» Калифорнийский университет, Сан-Франциско Управление по вопросам разнообразия и информационно-пропагандистской деятельности. Доступно: 15 октября 2017 года.](https://diversity.ucsf.edu/resources/unconscious-bias)
5.  [«Бессознательное смещение» acas.org.uk Доступно: 15 октября 2017 года.](http://www.acas.org.uk/index.aspx?articleid=5433)