---
title: Extensible Markup Language (XML)
localeTitle: Расширяемый язык разметки (XML)
---
## Расширяемый язык разметки (XML)

XML - расширяемый язык разметки. Предназначен для описания произвольных документов. Он расширяемый, поскольку не использует предопределенный набор элементов (тэгов) для описания структуры документа. Вместо этого он обеспечивает механизм для определения таких элементов. В настоящий момент одно из основных применений XML - это обмен данными. Если сравнить XML и HTML, то в отличие от HTML у XML нет предопределенного набора тегов, и теги определяют прежде всего значение, а не представление.

## Синтаксис XML
Синтаксис XML - это правила, определяющие способ описания документов XML. Документы XML должны содержать один корневой элемент, который является родительским для всех других элементов:
```
<root> 
  <child> 
    <subchild>.....</subchild> 
  </child> 
 </root> 
```

#### XML должен иметь корневой элемент

В приведенном выше синтаксисе показан корневой элемент, который необходим при создании XML-кода. Это можно показать на примере:
```
<?xml version="1.0" encoding="UTF-8"?> 
 <note> 
  <to>Tove</to> 
  <from>Jani</from> 
  <heading>Reminder</heading> 
  <body>Don't forget me this weekend!</body> 
 </note> 
```

В этом примере «note» является корневым элементом.

*   Преимущества использования XML:
    
    *   Простота. XML-документы - это обычные текстовые файлы, которые могут быть созданы и отредактированы с помощью любого текстового редактора.
    *   Независимость поставщиков
    *   Независимость платформы
    *   Обширная инфраструктура
    
*   Недостатки использования XML:
    
    *   Подробный и громоздкий синтаксис
    *   Очень неэффективное хранение
    

В языке Computer язык eXtensible Markup Language (XML) - это тот, который определяет набор или блок правил, которые позже используются для кодирования документов в таком формате, который является как машинным, так и человеко-читаемым.

Синтаксически XML и HTML похожи, но есть основное отличие: XML предназначен, чтобы описывать информацию и фокусирован только на этом. HTML, в свою очередь, сосредоточен на отображении (оформлении) информации.

Кроме того, XML не использует предопределенные теги. Он использует теги, определенные пользователем.

Ниже приводится простота, вызванная XML:

1.  Облегчает обмен данными
2.  Облегчает передачу данных
3.  Упрощает изменения платформы
4.  Увеличивает доступность данных

И главным достижением стало то, что он стал Рекомендацией W3C уже в феврале 1998 года.

### Больше информации

*   [Страница в Википедии](https://ru.wikipedia.org/wiki/XML)
*   [Введение в XML на сайте IBM для разработчиков](https://www.ibm.com/developerworks/ru/xml/newto/)
