const passport = require('passport');
const bcrypt = require('bcrypt');

module.exports = function(app, db) {

  app.route('/')
  .get(allowRedrock, (req, res) => {
    // res.sendFile(process.cwd() + '/views/index.html');
    res.render(process.cwd() + "/views/pug/index.pug", {
      title: "Home page",
      message: "Please login",
      showLogin: true,
      showRegistration: true
    });
  });

function allowRedrock(req, res, next) {
  res.setHeader("Access-Control-Allow-Origin", [
    "http://workbench.redrockcodecamp.org"
    // "http://127.0.0.1:5500"
  ]);
  next();
}

app.route("/login")
.post(
  allowRedrock, 
  passport.authenticate('local', { 
    failureRedirect: '/'
  }), (req, res) => {
    res.redirect("/profile");
  });

  // passport.authenticate("local", (err, user) => {
  //   if (!user) {
  //     console.log("Failed login; redirecting to /")
  //     res.redirect("/");
  //     res.end("Failed to authenticate!");
  //   } else {
  //     console.log("Successful login for " + user.username + "; redirecting to /profile")
  //     res.redirect("/profile");
  //     res.end("Authenticated!");
  //   }
  // }))

function ensureAuthenticated(req,res,next) {
  if (req.isAuthenticated()) {
    return next();
  }
  res.redirect('/');
}

app.route("/profile")
.get(allowRedrock, ensureAuthenticated, (req,res) => {
  console.log("About to render profile for " + req.user.username);
  res.render(process.cwd() + '/views/pug/profile.pug', {
    username: req.user.username
  });
});

app.route('/logout')
.get(allowRedrock, (req,res) => {

  if (req.user) console.log("Logging out: " + req.user.username);
  req.logout();
  res.redirect('/');
});

app.route("/register")
.post(
  allowRedrock,
  (req, res, next) => {
    db.collection("users").findOne({ username: req.body.username }, function(
      err,
      user
    ) {
      if (err) {
        next(err);
      } else if (user) {
        res.redirect("/");
      } else {
        bcrypt.hash(req.body.password, 12).then(hash => {
          db.collection("users").insertOne(
            { username: req.body.username, password: hash },
            (err, doc) => {
              if (err) {
                res.redirect("/");
              } else {
                next(null, user);
              }
            }
          );
        });
      }
    });
  },
  passport.authenticate("local", { failureRedirect: "/" }),
  allowRedrock,
  (req, res, next) => {
    res.redirect("/profile");
  }
);
};