"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.render = render;

var _document = _interopRequireDefault(require("./document"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function render(html) {
  var container = _document.default.createElement('div');

  container.innerHTML = html;
  return {
    container,
    queryByTestId: function queryByTestId(testId) {
      return container.querySelector(`[data-testid="${testId}"]`);
    }
  };
}