"use strict";

var _testUtils = require("./helpers/test-utils");

test('.toBeEmpty', function () {
  var _render = (0, _testUtils.render)(`
    <span data-testid="not-empty">
        <span data-testid="empty"></span>
        <svg data-testid="svg-empty"></svg>
    </span>`),
      queryByTestId = _render.queryByTestId;

  var empty = queryByTestId('empty');
  var notEmpty = queryByTestId('not-empty');
  var svgEmpty = queryByTestId('svg-empty');
  var nonExistantElement = queryByTestId('not-exists');
  var fakeElement = {
    thisIsNot: 'an html element'
  };
  expect(empty).toBeEmpty();
  expect(svgEmpty).toBeEmpty();
  expect(notEmpty).not.toBeEmpty(); // negative test cases wrapped in throwError assertions for coverage.

  expect(function () {
    return expect(empty).not.toBeEmpty();
  }).toThrowError();
  expect(function () {
    return expect(svgEmpty).not.toBeEmpty();
  }).toThrowError();
  expect(function () {
    return expect(notEmpty).toBeEmpty();
  }).toThrowError();
  expect(function () {
    return expect(fakeElement).toBeEmpty();
  }).toThrowError();
  expect(function () {
    expect(nonExistantElement).toBeEmpty();
  }).toThrowError();
});